/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal.dispatchers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.components.secdispatcher.Dispatcher;
import org.codehaus.plexus.components.secdispatcher.DispatcherMeta;
import org.codehaus.plexus.components.secdispatcher.MasterSource;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;

@Singleton
@Named(value="masterSourceLookup")
public class MasterSourceLookupDispatcher
implements Dispatcher,
DispatcherMeta {
    public static final String NAME = "masterSourceLookup";
    protected final Collection<MasterSource> sources;

    @Inject
    public MasterSourceLookupDispatcher(Collection<MasterSource> sources) {
        this.sources = sources;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String displayName() {
        return "Master Source Lookup Dispatcher";
    }

    @Override
    public Collection<DispatcherMeta.Field> fields() {
        return Collections.emptyList();
    }

    @Override
    public Dispatcher.EncryptPayload encrypt(String str, Map<String, String> attributes, Map<String, String> config) throws SecDispatcherException {
        this.decrypt(str, attributes, config);
        return new Dispatcher.EncryptPayload(attributes, str);
    }

    @Override
    public String decrypt(String str, Map<String, String> attributes, Map<String, String> config) throws SecDispatcherException {
        Optional<String> plain = this.sources.stream().map(source -> source.handle(str)).filter(Objects::nonNull).findFirst();
        if (plain.isPresent()) {
            return plain.get();
        }
        throw new SecDispatcherException("No master source found for : " + str);
    }

    @Override
    public SecDispatcher.ValidationResponse validateConfiguration(Map<String, String> config) {
        Map<SecDispatcher.ValidationResponse.Level, List<String>> report = Collections.singletonMap(SecDispatcher.ValidationResponse.Level.INFO, List.of("Configured Source configuration valid"));
        return new SecDispatcher.ValidationResponse(this.getClass().getSimpleName(), true, report, Collections.emptyList());
    }
}

