// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Copyright (C) 2023 Intel Corporation
//
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#include "support/test_config.h"

#include "oneapi/dpl/dynamic_selection"

#include "support/test_dynamic_selection_utils.h"
#include "support/inline_backend.h"
#include "support/utils.h"

int
main()
{
    try
    {
        //tests using default backend and only a resource type. (no user backend provided)
        using policy_t = oneapi::dpl::experimental::dynamic_load_policy<int, oneapi::dpl::identity,
                                                                        TestUtils::int_inline_backend_t<>>;
        std::vector<int> u{4, 5, 6, 7};

        // should always pick the "offset" device since executed inline
        // there is no overlap and so "offset" is always unloaded at selection time
        auto f = [u](int) { return u[0]; };

        EXPECT_EQ(0, (test_initialization<policy_t, int>(u)), "");
        EXPECT_EQ(0, (test_submit_and_wait_on_event<policy_t, TestUtils::int_inline_backend_t<>>(u, f)), "");
        EXPECT_EQ(0, (test_submit_and_wait<policy_t, TestUtils::int_inline_backend_t<>>(u, f)), "");
    }
    catch (const std::exception& exc)
    {
        std::stringstream str;

        str << "Exception occurred";
        if (exc.what())
            str << " : " << exc.what();

        TestUtils::issue_error_message(str);
    }

    return TestUtils::done();
}
