/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessages;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public abstract class AbstractFileSetCheck
extends AbstractViolationReporter
implements FileSetCheck {
    private MessageDispatcher mDispatcher;
    private String[] mFileExtensions = new String[0];
    private final LocalizedMessages mMessages = new LocalizedMessages();
    private String mCharset = System.getProperty("file.encoding", "UTF-8");

    public void destroy() {
    }

    public String getCharset() {
        return this.mCharset;
    }

    public void setCharset(String aCharset) throws UnsupportedEncodingException {
        try {
            new String(new byte[0], aCharset);
        }
        catch (UnsupportedEncodingException es) {
            String message = "unsupported charset: " + es.getMessage();
            throw new UnsupportedEncodingException(message);
        }
        this.mCharset = aCharset;
    }

    public final void setMessageDispatcher(MessageDispatcher aDispatcher) {
        this.mDispatcher = aDispatcher;
    }

    protected final MessageDispatcher getMessageDispatcher() {
        return this.mDispatcher;
    }

    protected final File[] filter(File[] aFiles) {
        if (this.mFileExtensions == null || this.mFileExtensions.length == 0) {
            return aFiles;
        }
        ArrayList<File> files = new ArrayList<File>(aFiles.length);
        for (int i = 0; i < aFiles.length; ++i) {
            File f = aFiles[i];
            String fileName = f.getName();
            for (int j = 0; j < this.mFileExtensions.length; ++j) {
                String fileExtension = this.mFileExtensions[j];
                if (!fileName.endsWith(fileExtension)) continue;
                files.add(f);
            }
        }
        return files.toArray(new File[files.size()]);
    }

    public final void setFileExtensions(String[] aExtensions) {
        if (aExtensions == null) {
            this.mFileExtensions = null;
            return;
        }
        this.mFileExtensions = new String[aExtensions.length];
        for (int i = 0; i < aExtensions.length; ++i) {
            String extension = aExtensions[i];
            this.mFileExtensions[i] = extension.startsWith(".") ? extension : "." + extension;
        }
    }

    protected final LocalizedMessages getMessageCollector() {
        return this.mMessages;
    }

    protected final void log(int aLine, String aKey, Object[] aArgs) {
        this.log(aLine, 0, aKey, aArgs);
    }

    protected final void log(int aLineNo, int aColNo, String aKey, Object[] aArgs) {
        this.getMessageCollector().add(new LocalizedMessage(aLineNo, aColNo, this.getMessageBundle(), aKey, aArgs, this.getSeverityLevel(), this.getId(), this.getClass()));
    }

    protected final void fireErrors(String aFileName) {
        LocalizedMessage[] errors = this.getMessageCollector().getMessages();
        this.getMessageCollector().reset();
        this.getMessageDispatcher().fireErrors(aFileName, errors);
    }
}

