local renderer = new PcfRenderer {
  converters {
    ["^apple"] = (it) -> it.toUpperCase()
    ["^[*].apple"] = (it) -> it.toUpperCase()
    ["^[apple]"] = (it) -> it.toUpperCase()
  }
}

local properties = renderer.renderDocument(
  new Dynamic {
    apple = "yes"
    banana {
      apple = "no"
    }
  })

res1 = properties.contains("YES")
res2 = properties.contains("no")
res3 = !properties.contains("yes")
res4 = !properties.contains("NO")

local elements = renderer.renderDocument(
  new Dynamic {
    new {
      apple = "yes"
    }
    new {
      new {
        apple = "no"
      }
    }
  })

res5 = elements.contains("YES")
res6 = elements.contains("no")
res7 = !elements.contains("yes")
res8 = !elements.contains("NO")

local entries = renderer.renderValue(
  new Dynamic {
    ["apple"] = "yes"
    ["banana"] {
      ["apple"] = "no"
    }
  })

res9 = entries.contains("YES")
res10 = entries.contains("no")
res11 = !entries.contains("yes")
res12 = !entries.contains("NO")

