//===----------------------------------------------------------------------===//
// Copyright © 2024-2025 Apple Inc. and the Pkl project authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//

/// A renderer for [Protocol Buffers](https://developers.google.com/protocol-buffers).
/// Note: This module is _experimental_ and not ready for production use.
@ModuleInfo { minPklVersion = "0.30.0" }
module pkl.protobuf

import "pkl:reflect"

/// A renderer for [Protocol Buffers](https://developers.google.com/protocol-buffers).
/// Note: This class is _experimental_ and not ready for production use.
///
/// As of this release, only Protocol Buffers' text format is supported.
class Renderer extends ValueRenderer {
  /// The characters to use for indenting output.
  ///
  /// Defaults to two spaces.
  indent: String = "  "

  external function renderDocument(value: Any): String

  external function renderValue(value: Any): String

  /// Returns the canonical name for [type].
  external function renderType(type: reflect.Type): String
}
