/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.AlternativeBillingListener;
import com.android.billingclient.api.BillingClientImpl;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.InAppMessageParams;
import com.android.billingclient.api.InAppMessageResponseListener;
import com.android.billingclient.api.ProductDetailsResponseListener;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.QueryProductDetailsParams;
import com.android.billingclient.api.QueryPurchaseHistoryParams;
import com.android.billingclient.api.QueryPurchasesParams;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.api.zzar;
import com.android.billingclient.api.zzaz;
import com.android.billingclient.api.zzbc;
import com.android.billingclient.api.zzbe;
import com.android.billingclient.api.zzd;
import com.android.billingclient.api.zzi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class BillingClient {
    @AnyThread
    public abstract int getConnectionState();

    @AnyThread
    @NonNull
    public static Builder newBuilder(@NonNull Context context) {
        Context context2;
        return new Builder(context2, null);
    }

    @AnyThread
    @NonNull
    public abstract BillingResult isFeatureSupported(@NonNull String var1);

    @UiThread
    @NonNull
    public abstract BillingResult launchBillingFlow(@NonNull Activity var1, @NonNull BillingFlowParams var2);

    @UiThread
    @NonNull
    public abstract BillingResult showInAppMessages(@NonNull Activity var1, @NonNull InAppMessageParams var2, @NonNull InAppMessageResponseListener var3);

    @AnyThread
    public abstract void acknowledgePurchase(@NonNull AcknowledgePurchaseParams var1, @NonNull AcknowledgePurchaseResponseListener var2);

    @AnyThread
    public abstract void consumeAsync(@NonNull ConsumeParams var1, @NonNull ConsumeResponseListener var2);

    @AnyThread
    public abstract void endConnection();

    @AnyThread
    public abstract void queryProductDetailsAsync(@NonNull QueryProductDetailsParams var1, @NonNull ProductDetailsResponseListener var2);

    @AnyThread
    public abstract void queryPurchaseHistoryAsync(@NonNull QueryPurchaseHistoryParams var1, @NonNull PurchaseHistoryResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void queryPurchaseHistoryAsync(@NonNull String var1, @NonNull PurchaseHistoryResponseListener var2);

    @AnyThread
    public abstract void queryPurchasesAsync(@NonNull QueryPurchasesParams var1, @NonNull PurchasesResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void queryPurchasesAsync(@NonNull String var1, @NonNull PurchasesResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void querySkuDetailsAsync(@NonNull SkuDetailsParams var1, @NonNull SkuDetailsResponseListener var2);

    @AnyThread
    public abstract void startConnection(@NonNull BillingClientStateListener var1);

    @AnyThread
    public abstract boolean isReady();

    @AnyThread
    public static final class Builder {
        private volatile String zza;
        private volatile zzbe zzb;
        private final Context zzc;
        private volatile PurchasesUpdatedListener zzd;
        private volatile zzaz zze;
        private volatile zzar zzf;
        private volatile AlternativeBillingListener zzg;

        /*
         * WARNING - void declaration
         */
        @zzd
        @NonNull
        public Builder enableAlternativeBilling(@NonNull AlternativeBillingListener alternativeBillingListener) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        @NonNull
        public Builder enablePendingPurchases() {
            zzbc zzbc2 = new zzbc(null);
            zzbc2.zza();
            this.zzb = zzbc2.zzb();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setListener(@NonNull PurchasesUpdatedListener listener) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public BillingClient build() {
            if (this.zzc == null) {
                throw new IllegalArgumentException("Please provide a valid Context.");
            }
            if (this.zzd == null) throw new IllegalArgumentException("Please provide a valid listener for purchases updates.");
            if (this.zzd != null) {
            }
            if (this.zzb == null) throw new IllegalArgumentException("Pending purchases for one-time products must be supported.");
            if (this.zzd == null && this.zzg != null) throw new IllegalArgumentException("Please provide a valid listener for Google Play Billing purchases updates when enabling Alternative Billing.");
            if (this.zzd == null) return new BillingClientImpl(null, this.zzb, this.zzc, null, null);
            return new BillingClientImpl(null, this.zzb, this.zzc, this.zzd, this.zzg, null);
        }

        /* synthetic */ Builder(Context context, zzi zzi2) {
            this.zzc = context;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionState {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int CLOSED = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BillingResponseCode {
        @Deprecated
        public static final int SERVICE_TIMEOUT = -3;
        public static final int FEATURE_NOT_SUPPORTED = -2;
        public static final int SERVICE_DISCONNECTED = -1;
        public static final int OK = 0;
        public static final int USER_CANCELED = 1;
        public static final int SERVICE_UNAVAILABLE = 2;
        public static final int BILLING_UNAVAILABLE = 3;
        public static final int ITEM_UNAVAILABLE = 4;
        public static final int DEVELOPER_ERROR = 5;
        public static final int ERROR = 6;
        public static final int ITEM_ALREADY_OWNED = 7;
        public static final int ITEM_NOT_OWNED = 8;
        public static final int NETWORK_ERROR = 12;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
        @NonNull
        public static final String SUBSCRIPTIONS = "subscriptions";
        @NonNull
        public static final String SUBSCRIPTIONS_UPDATE = "subscriptionsUpdate";
        @NonNull
        public static final String PRICE_CHANGE_CONFIRMATION = "priceChangeConfirmation";
        @NonNull
        public static final String IN_APP_MESSAGING = "bbb";
        @NonNull
        public static final String PRODUCT_DETAILS = "fff";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProductType {
        @NonNull
        public static final String INAPP = "inapp";
        @NonNull
        public static final String SUBS = "subs";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Deprecated
    public static @interface SkuType {
        @NonNull
        public static final String INAPP = "inapp";
        @NonNull
        public static final String SUBS = "subs";
    }
}

