# Maintainers

This file contains a list of the maintainers of the tldr-pages project.

> [!NOTE]
> Only the people marked with **bold** are currently in the indicated role.
> The other entries are kept for historical record.

There are three types of maintainers, as described in [COMMUNITY-ROLES.md](https://github.com/tldr-pages/tldr/blob/main/COMMUNITY-ROLES.md#when-to-change-roles): repository collaborators, organization members,
and organization owners — each having specific roles in maintaining the project, as outlined below.

In general terms, all maintainers are expected to follow the [Maintainer's guide](contributing-guides/maintainers-guide.md).

## Repository collaborators

Repository collaborators have write access to the tldr repository, which allows them to label, edit and close issues/pull requests, as well as review and merge pull requests from other contributors.
If you are an owner of the organization, you can see an automated list [here](https://github.com/tldr-pages/tldr/settings/collaboration).

- **Jeef ([@jeeftor](https://github.com/jeeftor))**:
  [12 March 2017](https://github.com/tldr-pages/tldr/issues/1209#issuecomment-285924778) — present
- **Max Xu ([@maxsxu](https://github.com/maxsxu))**:
  [11 January 2018](https://github.com/tldr-pages/tldr/issues/1885) — present
- **David Bialik ([@AnimiVulpis](https://github.com/AnimiVulpis))**:
  [5 November 2018](https://github.com/tldr-pages/tldr/issues/2556) — present
- **Andrik Albuquerque ([@andrik](https://github.com/andrik))**:
  [8 May 2019](https://github.com/tldr-pages/tldr/issues/2988) — present
- **Ivan Aracki ([@Aracki](https://github.com/Aracki))**:
  [8 May 2019](https://github.com/tldr-pages/tldr/issues/2988) — present
- **Pierre Rudloff ([@Rudloff](https://github.com/Rudloff))**:
  [16 November 2019](https://github.com/tldr-pages/tldr/issues/3580) — present
- **Guido Lena Cota ([@glenacota](https://github.com/glenacota))**:
  [19 October 2020](https://github.com/tldr-pages/tldr/issues/4763) — present
- **Sahil Dhiman ([@sahilister](https://github.com/sahilister))**:
  [27 November 2020](https://github.com/tldr-pages/tldr/issues/4994) - present
- **Adam Herst ([@aherst](https://github.com/aherst))**:
  [21 April 2021](https://github.com/tldr-pages/tldr/issues/5810) — present
- **Nicolas Kosinski ([@nicokosi](https://github.com/nicokosi))**:
  [03 May 2021](https://github.com/tldr-pages/tldr/issues/5873) — present
- **Patrice Denis ([@patricedenis](https://github.com/patricedenis))**:
  [10 May 2021](https://github.com/tldr-pages/tldr/issues/5919) — present
- **Reinhart Previano Koentjoro ([@reinhart1010](https://github.com/reinhart1010))**:
  [23 November 2021](https://github.com/tldr-pages/tldr/issues/7404) — present
- **258204 ([@258204](https://github.com/258204))**:
  [10 December 2021](https://github.com/tldr-pages/tldr/issues/7522) — present
- **Nicolas Hansse ([@Nico385412](https://github.com/Nico385412))**:
  [19 July 2022](https://github.com/tldr-pages/tldr/issues/8224) — present
- **Adrien Thebo ([@adrienthebo](https://github.com/adrienthebo))**:
  [17 August 2022](https://github.com/tldr-pages/tldr/issues/8321) — present
- **Cairn ([@CairnThePerson](https://github.com/CairnThePerson))**:
  [1 September 2022](https://github.com/tldr-pages/tldr/issues/8438) — present
- **Lucas Schneider ([@schneiderl](https://github.com/schneiderl))**:
  [11 April 2019](https://github.com/tldr-pages/tldr/issues/2898) — [17 January 2020](https://github.com/tldr-pages/tldr/issues/3764), [7 February 2023](https://github.com/tldr-pages/tldr/issues/10674) — present
- **HoJeong Im ([@IMHOJEONG](https://github.com/IMHOJEONG))**:
  [24 October 2023](https://github.com/tldr-pages/tldr/issues/11200) — present
- **Leon ([@leonvsc](https://github.com/leonvsc))**:
  [14 November 2023](https://github.com/tldr-pages/tldr/issues/11495) — present
- **Matthew Peveler ([@MasterOdin](https://github.com/MasterOdin))**:
  [9 January 2021](https://github.com/tldr-pages/tldr/issues/5122) — [18 March 2021](https://github.com/tldr-pages/tldr/issues/5473), [15 November 2023](https://github.com/tldr-pages/tldr/issues/11509) — present
- **cyqsimon ([@cyqsimon](https://github.com/cyqsimon))**:
  [28 December 2023](https://github.com/tldr-pages/tldr/issues/11864) — present
- **Jongwon Youn ([@korECM](https://github.com/korECM))**:
  [29 December 2023](https://github.com/tldr-pages/tldr/issues/11892) — present
- **Mohammad Reza Soleimani ([@MrMw3](https://github.com/MrMw3))**:
  [07 January 2024](https://github.com/tldr-pages/tldr/issues/12011) — present
- **Alexandre ZANNI ([@noraj](https://github.com/noraj))**:
  [22 February 2024](https://github.com/tldr-pages/tldr/issues/12324) — present
- **Shashank Hebbar ([@quantumflo](https://github.com/quantumflo))**:
  [13 November 2023](https://github.com/tldr-pages/tldr/issues/11460) — [27 March 2024](https://github.com/tldr-pages/tldr/issues/12209), [30 March 2024](https://github.com/tldr-pages/tldr/pull/11622#issuecomment-2027932865) — present
- **Debaudh Ghosh ([@debghs](https://github.com/debghs))**:
  [16 August 2024](https://github.com/tldr-pages/tldr/issues/13450) — present
- **jxu ([@jxu](https://github.com/jxu))**:
  [18 August 2024](https://github.com/tldr-pages/tldr/issues/13451) — present
- **Iván Hernández Cazorla ([@ivanhercaz](https://github.com/ivanhercaz))**:
  [24 December 2019](https://github.com/tldr-pages/tldr/issues/3690) — [5 January 2020](https://github.com/tldr-pages/tldr/issues/3736), [22 September 2024](https://github.com/tldr-pages/tldr/issues/5932) — present
- **Yi Liu ([@LiLittleCat](https://github.com/LiLittleCat))**:
  [23 September 2024](https://github.com/tldr-pages/tldr/issues/13780) — present
- **Karthik Vallamsetla ([@karthik-script](https://github.com/karthik-script))**:
  [01 November 2024](https://github.com/tldr-pages/tldr/issues/14539) — present
- **Igor Támara ([@ikks](https://github.com/ikks))**:
  [01 November 2024](https://github.com/tldr-pages/tldr/issues/14536) — present
- **Zamoca42 ([@Zamoca42](https://github.com/Zamoca42))**:
  [02 November 2024](https://github.com/tldr-pages/tldr/issues/14538) — present
- **CodePsy-2001 ([@CodePsy-2001](https://github.com/CodePsy-2001))**:
  [02 November 2024](https://github.com/tldr-pages/tldr/issues/14537#issuecomment-2457381463) — present
- **Axel Navarro ([@navarroaxel](https://github.com/navarroaxel))**:
  [24 August 2020](https://github.com/tldr-pages/tldr/issues/4291) — [5 October 2020](https://github.com/tldr-pages/tldr/issues/4504), [14 November 2024](https://github.com/tldr-pages/tldr/issues/14541) — present
- **witt ([@witt-bit](https://github.com/witt-bit))**:
  [14 January 2025](https://github.com/tldr-pages/tldr/issues/15514) — present
- **Amine LOUHICHI ([@aminelch](https://github.com/aminelch))**:
  [08 April 2025](https://github.com/tldr-pages/tldr/issues/16126) — present
- **Kristopher Sandoval ([@KristopherLeads](https://github.com/KristopherLeads))**:
  [29 June 2025](https://github.com/tldr-pages/tldr/issues/17024) — present
- **Harshavardhan ([@TheRootDaemon](https://github.com/TheRootDaemon))**:
  [17 August 2025](https://github.com/tldr-pages/tldr/issues/17708) — present
- **Sarijen ([@Sarijen](https://github.com/Sarijen))**:
  [21 August 2025](https://github.com/tldr-pages/tldr/issues/17757) — present
- **Adriano Inghingolo ([@SpikeTheDragon40k](https://github.com/SpikeTheDragon40k))**:
  [22 August 2025](https://github.com/tldr-pages/tldr/issues/17772) — present
- **Ali Nazzal ([@ali90h](https://github.com/ali90h))**:
  [10 September 2025](https://github.com/tldr-pages/tldr/issues/18069) — present
- **Sadeed Waseem ([@sadeeed](https://github.com/Sadeeed))**:
  [04 October 2025](https://github.com/tldr-pages/tldr/issues/18393) — present
- **Ivan Baluta ([@ivanbaluta](https://github.com/ivanbaluta))**:
  [03 November 2025](https://github.com/tldr-pages/tldr/issues/19176) — present
- **Sahil Afrid Farookhi ([@msaf9](https://github.com/msaf9))**: 
  [04 November 2025](https://github.com/tldr-pages/tldr/issues/19189) — present
- **Meinard Francisco ([@znarfm](https://github.com/znarfm))**:
  [04 November 2025](https://github.com/tldr-pages/tldr/issues/19190) — present
- **Md Sakib Sadman Badhon ([@badhon495](https://github.com/badhon495))**:
  [06 November 2025](https://github.com/tldr-pages/tldr/issues/19235) — present
- **Mingliang Song ([@DustMerlin](https://github.com/DustMerlin)**:
  [13 November 2025](https://github.com/tldr-pages/tldr/issues/19336) — present
- **zhb4 ([@zhb4](https://github.com/zhb4))**:
  [14 November 2025](https://github.com/tldr-pages/tldr/issues/19339) — present
- **Emmanuel Ferdman ([@emmanuel-ferdman](https://github.com/emmanuel-ferdman))**:
  [22 November 2025](https://github.com/tldr-pages/tldr/issues/19549) — present
- Owen Voke ([@owenvoke](https://github.com/owenvoke)):
  [11 January 2018](https://github.com/tldr-pages/tldr/issues/1885) — [26 August 2018](https://github.com/tldr-pages/tldr/issues/2258)
- Marco Bonelli ([@mebeim](https://github.com/mebeim)):
  [28 January 2019](https://github.com/tldr-pages/tldr/issues/2735) — [8 April 2019](https://github.com/tldr-pages/tldr/issues/2874)
- Ein Verne ([@einverne](https://github.com/einverne)):
  [27 October 2019](https://github.com/tldr-pages/tldr/issues/3488) — [6 January 2020](https://github.com/tldr-pages/tldr/issues/3738)
- Zlatan Vasović ([@zlatanvasovic](https://github.com/zlatanvasovic)):
  [28 November 2019](https://github.com/tldr-pages/tldr/issues/3636) — [17 December 2019](https://github.com/tldr-pages/tldr/issues/3663)
- bl-ue ([@bl-ue](https://github.com/bl-ue)):
  [30 December 2020](https://github.com/tldr-pages/tldr/issues/5056) — [2 February 2021](https://github.com/tldr-pages/tldr/issues/5219)
- Tan Siret Akıncı ([@tansiret](https://github.com/tansiret)):
  [3 March 2021](https://github.com/tldr-pages/tldr/issues/5345) — [7 April 2021](https://github.com/tldr-pages/tldr/issues/5702)
- Florian Benscheidt ([@Waples](https://github.com/Waples)):
  [16 April 2021](https://github.com/tldr-pages/tldr/issues/5774) — [19 May 2021](https://github.com/tldr-pages/tldr/issues/5989)
- CleanMachine1 ([@CleanMachine1](https://github.com/CleanMachine1)):
  [14 May 2021](https://github.com/tldr-pages/tldr/issues/5961) — [14 June 2021](https://github.com/tldr-pages/tldr/issues/6123)
- Muhammad Falak R Wani ([@mfrw](https://github.com/mfrw)):
  [6 September 2018](https://github.com/tldr-pages/tldr/issues/2306) — [21 June 2021](https://github.com/tldr-pages/tldr/issues/6142)
- Seth Falco ([@SethFalco](https://github.com/SethFalco)):
  [19 May 2021](https://github.com/tldr-pages/tldr/issues/5993) - [21 June 2021](https://github.com/tldr-pages/tldr/issues/6149)
- Pixel Häußler ([@pixelcmtd](https://github.com/pixelcmtd)):
  [27 August 2021](https://github.com/tldr-pages/tldr/issues/6415) — [16 October 2022](https://github.com/tldr-pages/tldr/pull/9072#issuecomment-1279847932)
- Emily Grace Seville ([@EmilyGraceSeville7cf](https://github.com/EmilyGraceSeville7cf)):
  [19 January 2022](https://github.com/tldr-pages/tldr/issues/1209#issuecomment-285924778) — [24 April 2022](https://github.com/tldr-pages/tldr/issues/8053)
- K.B.Dharun Krishna ([@kbdharun](https://github.com/kbdharun)):
  [06 August 2022](https://github.com/tldr-pages/tldr/issues/8309) — [14 December 2022](https://github.com/tldr-pages/tldr/issues/9625)
- Lin Cheng Chieh ([@blueskyson](https://github.com/blueskyson)):
  [12 August 2021](https://github.com/tldr-pages/tldr/issues/6330) — [4 January 2023](https://github.com/tldr-pages/tldr/issues/9671)
- Lena Pastwa ([@acuteenvy](https://github.com/acuteenvy)):
  [13 May 2023](https://github.com/tldr-pages/tldr/issues/10187) — [21 June 2023](https://github.com/tldr-pages/tldr/issues/10406)
- Juri ([@gutjuri](https://github.com/gutjuri)):
  [06 October 2023](https://github.com/tldr-pages/tldr/issues/10874) — [24 October 2023](https://github.com/tldr-pages/tldr/issues/11201)
- Sebastiaan Speck ([@sebastiaanspeck](https://github.com/sebastiaanspeck)):
  [19 October 2023](https://github.com/tldr-pages/tldr/issues/11075) — [24 October 2023](https://github.com/tldr-pages/tldr/issues/11202)
- Isaac Vicente ([@isaacvicente](https://github.com/isaacvicente)):
  [20 September 2023](https://github.com/tldr-pages/tldr/issues/10737) — [29 December 2023](https://github.com/tldr-pages/tldr/issues/11918)
- Vitor Henrique ([@vitorhcl](https://github.com/vitorhcl)):
  [18 December 2023](https://github.com/tldr-pages/tldr/issues/11771) — [21 January 2024](https://github.com/tldr-pages/tldr/issues/12094)
- Geipro/Proscream ([@Geipro)](https://github.com/Geipro)):
  [19 November 2019](https://github.com/tldr-pages/tldr/issues/3592) — [27 March 2024](https://github.com/tldr-pages/tldr/issues/12209) (Removed during 2FA enforcement)
- Ruben Vereecken ([@rubenvereecken](https://github.com/rubenvereecken)):
  [18 January 2018](https://github.com/tldr-pages/tldr/issues/1878#issuecomment-358610454) — [27 March 2024](https://github.com/tldr-pages/tldr/issues/12209) (Removed during 2FA enforcement)
- Fazle Arefin ([@fazlearefin](https://github.com/fazlearefin)):
  [09 February 2024](https://github.com/tldr-pages/tldr/issues/12227) — [2 April 2024](https://github.com/tldr-pages/tldr/issues/12595)
- Alejandro Cervera ([@tricantivu](https://github.com/tricantivu)):
  [4 January 2024](https://github.com/tldr-pages/tldr/issues/11989) — [3 April 2024](https://github.com/tldr-pages/tldr/issues/12594)
- Magrid0 ([@Magrid0](https://github.com/Magrid0)):
  [22 October 2023](https://github.com/tldr-pages/tldr/issues/11159) — [3 May 2024](https://github.com/tldr-pages/tldr/issues/12717)
- Darío Hereñú ([@kant](https://github.com/kant)):
  [20 September 2023](https://github.com/tldr-pages/tldr/issues/10738) — [3 May 2024](https://github.com/tldr-pages/tldr/issues/12718)
- Wiktor Perskawiec ([@spageektti](https://github.com/spageektti)):
  [11 May 2024](https://github.com/tldr-pages/tldr/issues/12776) — [1 June 2024](https://github.com/tldr-pages/tldr/issues/12869)
- Managor ([@Managor](https://github.com/Managor)):
  [4 September 2023](https://github.com/tldr-pages/tldr/issues/10611) — [3 October 2024](https://github.com/tldr-pages/tldr/issues/13956)
- Renie ([@renie](https://github.com/renie)):
  [03 October 2024](https://github.com/tldr-pages/tldr/issues/13946) — [23 October 2024](https://github.com/tldr-pages/tldr/issues/14343)
- Machiavelli ([@MachiavelliII](https://github.com/MachiavelliII)):
  [21 January 2025](https://github.com/tldr-pages/tldr/issues/15564) — [27 Mar 2025](https://github.com/tldr-pages/tldr/issues/16036)
- Nelson Figueroa ([@nelsonfigueroa](https://github.com/nelsonfigueroa)):
  [21 September 2024](https://github.com/tldr-pages/tldr/issues/13781) — [29 June 2025](https://github.com/tldr-pages/tldr/issues/17025)
- Dylan McGivern ([@dmmqz](https://github.com/dmmqz)):
  [30 May 2025](https://github.com/tldr-pages/tldr/issues/16671) — [30 June 2025](https://github.com/tldr-pages/tldr/issues/17026)
- Marcher Simon ([@marchersimon](https://github.com/marchersimon)):
  [9 March 2021](https://github.com/tldr-pages/tldr/issues/5390) — [9 April 2021](https://github.com/tldr-pages/tldr/issues/5722), [20 November 2023](https://github.com/tldr-pages/tldr/issues/11381) — [12 July 2025](https://github.com/tldr-pages/tldr/issues/17214)


## Organization members

In addition to everything that repository collaborators can do, organization members have write access to all the repositories in the tldr-pages organization, and [a few extra maintenance capabilities](https://docs.github.com/en/organizations/managing-peoples-access-to-your-organization-with-roles/permission-levels-for-an-organization).
An automated list can be found [here](https://github.com/orgs/tldr-pages/people).

- **Ein Verne ([@einverne](https://github.com/einverne))**:
  [6 January 2020](https://github.com/tldr-pages/tldr/issues/3738) — present
- **Tan Siret Akıncı ([@tansiret](https://github.com/tansiret))**:
  [7 April 2021](https://github.com/tldr-pages/tldr/issues/5702) — present
- **Florian Benscheidt ([@Waples](https://github.com/Waples))**:
  [19 May 2021](https://github.com/tldr-pages/tldr/issues/5989) — present
- **Seth Falco ([@SethFalco](https://github.com/SethFalco))**:
  [21 June 2021](https://github.com/tldr-pages/tldr/issues/6149) — present
- **Isaac Vicente ([@isaacvicente](https://github.com/isaacvicente))**:
  [29 December 2023](https://github.com/tldr-pages/tldr/issues/11918) — present
- **Vitor Henrique ([@vitorhcl](https://github.com/vitorhcl))**:
  [21 January 2024](https://github.com/tldr-pages/tldr/issues/12094) — present
- **Fazle Arefin ([@fazlearefin](https://github.com/fazlearefin))**:
  [2 April 2024](https://github.com/tldr-pages/tldr/issues/12595) — present
- **Alejandro Cervera ([@tricantivu](https://github.com/tricantivu))**:
  [3 April 2024](https://github.com/tldr-pages/tldr/issues/12594) — present
- **Magrid0 ([@Magrid0](https://github.com/Magrid0))**:
  [3 May 2024](https://github.com/tldr-pages/tldr/issues/12717) — present
- **Darío Hereñú ([@kant](https://github.com/kant))**:
  [3 May 2024](https://github.com/tldr-pages/tldr/issues/12718) — present
- **Renie ([@renie](https://github.com/renie))**:
  [23 October 2024](https://github.com/tldr-pages/tldr/issues/14343) — present
- **Machiavelli ([@MachiavelliII](https://github.com/MachiavelliII))**:
  [27 Mar 2025](https://github.com/tldr-pages/tldr/issues/16036) — present
- **Nelson Figueroa ([@nelsonfigueroa](https://github.com/nelsonfigueroa))**:
  [29 June 2025](https://github.com/tldr-pages/tldr/issues/17025) — present
- **Dylan McGivern ([@dmmqz](https://github.com/dmmqz))**:
  [30 June 2025](https://github.com/tldr-pages/tldr/issues/17026) — present
- Owen Voke ([@owenvoke](https://github.com/owenvoke))
  [26 August 2018](https://github.com/tldr-pages/tldr/issues/2258) — [8 May 2019](https://github.com/tldr-pages/tldr/issues/2989)
- Marco Bonelli ([@mebeim](https://github.com/mebeim)):
  [8 April 2019](https://github.com/tldr-pages/tldr/issues/2874) — [20 December 2019](https://github.com/tldr-pages/tldr/issues/3672)
- Zlatan Vasović ([@zlatanvasovic](https://github.com/zlatanvasovic)):
  [17 December 2019](https://github.com/tldr-pages/tldr/issues/3663) — [18 June 2020](https://github.com/tldr-pages/tldr/issues/4113)
- Lucas Schneider ([@schneiderl](https://github.com/schneiderl)):
  [17 January 2020](https://github.com/tldr-pages/tldr/issues/3764) — [3 February 2021](https://github.com/tldr-pages/tldr/issues/5224)
- Axel Navarro ([@navarroaxel](https://github.com/navarroaxel)):
  [5 October 2020](https://github.com/tldr-pages/tldr/issues/4504) — [7 April 2021](https://github.com/tldr-pages/tldr/issues/5703)
- bl-ue ([@bl-ue](https://github.com/bl-ue)):
  [2 February 2021](https://github.com/tldr-pages/tldr/issues/5219) — [25 June 2021](https://matrix.to/#/!zXiOpjSkFTvtMpsenJ:gitter.im/$qCyBANu8Ub_GKJgwh0zKlVSgWASLYxYJXBn4NDEEQPw)
- CleanMachine1 ([@CleanMachine1](https://github.com/CleanMachine1)):
  [14 June 2021](https://github.com/tldr-pages/tldr/issues/6123) — [14 December 2021](https://github.com/tldr-pages/tldr/issues/7541)
- Marcher Simon ([@marchersimon](https://github.com/marchersimon)):
  [9 April 2021](https://github.com/tldr-pages/tldr/issues/5722) — [9 August 2022](https://github.com/tldr-pages/tldr/issues/7540)
- Emily Grace Seville ([@EmilyGraceSeville7cf](https://github.com/EmilyGraceSeville7cf)):
  [25 April 2022](https://github.com/tldr-pages/tldr/issues/8053) — [12 January 2022](https://matrix.to/#/!zXiOpjSkFTvtMpsenJ:gitter.im/$n3Jk7mhIzG6edTVUv6MkAoX_1N5z5MPRj2hclyrfKBI)
- Pixel Häußler ([@pixelcmtd](https://github.com/pixelcmtd)):
  [16 October 2022](https://github.com/tldr-pages/tldr/pull/9072#issuecomment-1279847932) — [10 May 2023](https://github.com/tldr-pages/tldr/pull/10056)
- Muhammad Falak R Wani ([@mfrw](https://github.com/mfrw)):
  [21 June 2021](https://github.com/tldr-pages/tldr/issues/6142) — [9 June 2023](https://github.com/tldr-pages/tldr/issues/10053)
- K.B.Dharun Krishna ([@kbdharun](https://github.com/kbdharun)):
  [14 December 2022](https://github.com/tldr-pages/tldr/issues/9625) — [19 June 2023](https://github.com/tldr-pages/tldr/issues/10057)
- Lin Cheng Chieh ([@blueskyson](https://github.com/blueskyson)):
  [4 January 2023](https://github.com/tldr-pages/tldr/issues/9671) — [7 July 2023](https://github.com/tldr-pages/tldr/issues/10054)
- Matthew Peveler ([@MasterOdin](https://github.com/MasterOdin)):
  [18 March 2021](https://github.com/tldr-pages/tldr/issues/5473) — [15 November 2023](https://github.com/tldr-pages/tldr/issues/11509)
- Lena Pastwa ([@acuteenvy](https://github.com/acuteenvy)):
  [21 June 2023](https://github.com/tldr-pages/tldr/issues/10406) — [27 December 2023](https://github.com/tldr-pages/tldr/issues/11839)
- Sebastiaan Speck ([@sebastiaanspeck](https://github.com/sebastiaanspeck)):
  [24 October 2023](https://github.com/tldr-pages/tldr/issues/11202) — [28 April 2024](https://github.com/tldr-pages/tldr/issues/12687)
- Juri ([@gutjuri](https://github.com/gutjuri)):
  [24 October 2023](https://github.com/tldr-pages/tldr/issues/11201) — [29 April 2024](https://github.com/tldr-pages/tldr/issues/12686)
- Iván Hernández Cazorla ([@ivanhercaz](https://github.com/ivanhercaz)):
  [5 January 2020](https://github.com/tldr-pages/tldr/issues/3736) — [22 September 2024](https://github.com/tldr-pages/tldr/issues/5932)
- Wiktor Perskawiec ([@spageektti](https://github.com/spageektti)):
  [1 June 2024](https://github.com/tldr-pages/tldr/issues/12869) — [29 June 2025](https://github.com/tldr-pages/tldr/issues/17028)
- Managor ([@Managor](https://github.com/Managor)):
  [3 October 2024](https://github.com/tldr-pages/tldr/issues/13956) — [29 June 2025](https://github.com/tldr-pages/tldr/issues/17029)

## Organization owners

Owners of the tldr-pages organization have admin access to all of its repositories and are responsible for performing role changes in the community.
An automated list can be found [here](https://github.com/orgs/tldr-pages/people).

- **Romain Prieto ([@rprieto](https://github.com/rprieto))**:
  created the project on [8 December 2013](https://github.com/tldr-pages/tldr/commit/11264d9b19000734a2d35ecbdbdebc0b0b45aed9)
- **Agniva De Sarker ([@agnivade](https://github.com/agnivade))**:
  [21 September 2016](https://github.com/tldr-pages/tldr/issues/9899) — present
- **Starbeamrainbowlabs ([@sbrl](https://github.com/sbrl))**:
  [19 April 2017](https://github.com/tldr-pages/tldr/issues/9899) — present
- **Owen Voke ([@owenvoke](https://github.com/owenvoke))**
  [8 May 2019](https://github.com/tldr-pages/tldr/issues/2989) — present
- **Marco Bonelli ([@mebeim](https://github.com/mebeim))**:
  [21 December 2019](https://github.com/tldr-pages/tldr/issues/3672) — present
- **CleanMachine1 ([@CleanMachine1](https://github.com/CleanMachine1))**:
  [14 December 2021](https://github.com/tldr-pages/tldr/issues/7541) — present
- **Pixel Häußler ([@pixelcmtd](https://github.com/pixelcmtd))**:
  [10 May 2023](https://github.com/tldr-pages/tldr/pull/10056) — present
- **Muhammad Falak R Wani ([@mfrw](https://github.com/mfrw))**:
  [9 June 2023](https://github.com/tldr-pages/tldr/pull/10355) — present
- **K.B.Dharun Krishna ([@kbdharun](https://github.com/kbdharun))**:
  [19 June 2023](https://github.com/tldr-pages/tldr/issues/10057) — present
- **Lin Cheng Chieh ([@blueskyson](https://github.com/blueskyson))**:
  [7 July 2023](https://github.com/tldr-pages/tldr/issues/10054) — present
- **Lena Pastwa ([@acuteenvy](https://github.com/acuteenvy))**:
  [27 December 2023](https://github.com/tldr-pages/tldr/issues/11839) — present
- **Sebastiaan Speck ([@sebastiaanspeck](https://github.com/sebastiaanspeck))**:
  [28 April 2024](https://github.com/tldr-pages/tldr/issues/12687) — present
- **Juri ([@gutjuri](https://github.com/gutjuri))**:
  [29 April 2024](https://github.com/tldr-pages/tldr/issues/12686) — present
- **Wiktor Perskawiec ([@spageektti](https://github.com/spageektti))**:
  [29 June 2025](https://github.com/tldr-pages/tldr/issues/17028) — present
- **Managor ([@Managor](https://github.com/Managor))**:
  [29 June 2025](https://github.com/tldr-pages/tldr/issues/17029) — present
- Igor Shubovych ([@igorshubovych](https://github.com/igorshubovych)):
  until [18 January 2018](https://github.com/tldr-pages/tldr/issues/1878#issuecomment-358610454)
- Ruben Vereecken ([@rubenvereecken](https://github.com/rubenvereecken)):
  until [18 January 2018](https://github.com/tldr-pages/tldr/issues/1878#issuecomment-358610454)
- Felix Yan ([@felixonmars](https://github.com/felixonmars)):
  until [18 January 2018](https://github.com/tldr-pages/tldr/issues/1878#issuecomment-358610454)
- Dan Zimmerman ([@danzimm](https://github.com/danzimm)):
  until [18 January 2018](https://github.com/tldr-pages/tldr/issues/1878#issuecomment-358610454)
- Eduardo Gurgel ([@edgurgel](https://github.com/edgurgel)):
  until [18 January 2018](https://github.com/tldr-pages/tldr/issues/1878#issuecomment-358610454)
- Arvid Gerstmann ([@Leandros](https://github.com/Leandros)):
  until [18 January 2018](https://github.com/tldr-pages/tldr/issues/1878#issuecomment-358610454)
- Leandro Ostera ([@leostera](https://github.com/leostera)):
  until [18 January 2018](https://github.com/tldr-pages/tldr/issues/1878#issuecomment-358610454)
- Waldir Pimenta ([@waldyrious](https://github.com/waldyrious)):
  until [26 August 2018](https://github.com/tldr-pages/tldr/issues/2257)
- Zlatan Vasović ([@zlatanvasovic](https://github.com/zlatanvasovic)):
  until [14 December 2021](https://github.com/tldr-pages/tldr/issues/7538)
- Lucas Schneider ([@schneiderl](https://github.com/schneiderl)):
  until [7 February 2023](https://github.com/tldr-pages/tldr/issues/10674)
- Marcher Simon ([@marchersimon](https://github.com/marchersimon)):
  until [20 November 2023](https://github.com/tldr-pages/tldr/issues/11381)
- Axel Navarro ([@navarroaxel](https://github.com/navarroaxel)):
  until [14 November 2024](https://github.com/tldr-pages/tldr/issues/14541)
