# g++

> Kompiliere C++ Quelldateien.
> Teil der GCC (GNU Compiler Collection).
> Weitere Informationen: <https://gcc.gnu.org/onlinedocs/gcc/C_002b_002b-Dialect-Options.html>.

- Kompiliere eine Quelldatei in eine ausführbare Binärdatei:

`g++ {{pfad/zu/quelldatei.cpp}} {{[-o|--output]}} {{pfad/zu/binärdatei}}`

- Zeige geläufige Fehler und Warnungen an:

`g++ {{pfad/zu/quelldatei.cpp}} -Wall {{[-o|--output]}} {{pfad/zu/binärdatei}}`

- Wähle einen Sprachstandard (C++98/C++11/C++14/C++17) für das Kompilieren:

`g++ {{pfad/zu/quelldatei.cpp}} -std={{C++98|C++11|C++14|C++17}} {{[-o|--output]}} {{pfad/zu/binärdatei}}`

- Binde Bibliotheken, die sich an einem anderen Pfad als die Quelldatei befinden, ein:

`g++ {{pfad/zu/quelldatei.cpp}} {{[-o|--output]}} {{pfad/zu/binärdatei}} -I{{pfad/zu/headerdatei}} -L{{pfad/zu/bibliothek}} -l{{bibliotheks_name}}`

- Kompiliere und linke mehrere Quelldateien in eine ausführbare Binärdatei:

`g++ -c {{pfad/zu/quelldatei_1.cpp pfad/zu/quelldatei_2.cpp ...}} && g++ {{[-o|--output]}} {{pfad/zu/binärdatei}} {{pfad/zu/quelldatei_1.o pfad/zu/quelldatei_2.o ...}}`

- Gib die Version von `g++` aus:

`g++ --version`
