/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package applyconfiguration

import (
	internal "github.com/traefik/traefik/v3/pkg/provider/kubernetes/crd/generated/applyconfiguration/internal"
	traefikiov1alpha1 "github.com/traefik/traefik/v3/pkg/provider/kubernetes/crd/generated/applyconfiguration/traefikio/v1alpha1"
	v1alpha1 "github.com/traefik/traefik/v3/pkg/provider/kubernetes/crd/traefikio/v1alpha1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
)

// ForKind returns an apply configuration type for the given GroupVersionKind, or nil if no
// apply configuration type exists for the given GroupVersionKind.
func ForKind(kind schema.GroupVersionKind) interface{} {
	switch kind {
	// Group=traefik.io, Version=v1alpha1
	case v1alpha1.SchemeGroupVersion.WithKind("BasicAuth"):
		return &traefikiov1alpha1.BasicAuthApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("Certificate"):
		return &traefikiov1alpha1.CertificateApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("Chain"):
		return &traefikiov1alpha1.ChainApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("CircuitBreaker"):
		return &traefikiov1alpha1.CircuitBreakerApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ClientAuth"):
		return &traefikiov1alpha1.ClientAuthApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ClientTLS"):
		return &traefikiov1alpha1.ClientTLSApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ClientTLSWithCAOptional"):
		return &traefikiov1alpha1.ClientTLSWithCAOptionalApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("Compress"):
		return &traefikiov1alpha1.CompressApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("DigestAuth"):
		return &traefikiov1alpha1.DigestAuthApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ErrorPage"):
		return &traefikiov1alpha1.ErrorPageApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ForwardAuth"):
		return &traefikiov1alpha1.ForwardAuthApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ForwardingTimeouts"):
		return &traefikiov1alpha1.ForwardingTimeoutsApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("HighestRandomWeight"):
		return &traefikiov1alpha1.HighestRandomWeightApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("IngressRoute"):
		return &traefikiov1alpha1.IngressRouteApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("IngressRouteRef"):
		return &traefikiov1alpha1.IngressRouteRefApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("IngressRouteSpec"):
		return &traefikiov1alpha1.IngressRouteSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("IngressRouteTCP"):
		return &traefikiov1alpha1.IngressRouteTCPApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("IngressRouteTCPSpec"):
		return &traefikiov1alpha1.IngressRouteTCPSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("IngressRouteUDP"):
		return &traefikiov1alpha1.IngressRouteUDPApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("IngressRouteUDPSpec"):
		return &traefikiov1alpha1.IngressRouteUDPSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("LoadBalancerSpec"):
		return &traefikiov1alpha1.LoadBalancerSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("Middleware"):
		return &traefikiov1alpha1.MiddlewareApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("MiddlewareRef"):
		return &traefikiov1alpha1.MiddlewareRefApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("MiddlewareSpec"):
		return &traefikiov1alpha1.MiddlewareSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("MiddlewareTCP"):
		return &traefikiov1alpha1.MiddlewareTCPApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("MiddlewareTCPSpec"):
		return &traefikiov1alpha1.MiddlewareTCPSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("Mirroring"):
		return &traefikiov1alpha1.MirroringApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("MirrorService"):
		return &traefikiov1alpha1.MirrorServiceApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ObjectReference"):
		return &traefikiov1alpha1.ObjectReferenceApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("PassiveServerHealthCheck"):
		return &traefikiov1alpha1.PassiveServerHealthCheckApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("RateLimit"):
		return &traefikiov1alpha1.RateLimitApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("Redis"):
		return &traefikiov1alpha1.RedisApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ResponseForwarding"):
		return &traefikiov1alpha1.ResponseForwardingApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("Retry"):
		return &traefikiov1alpha1.RetryApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("RootCA"):
		return &traefikiov1alpha1.RootCAApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("Route"):
		return &traefikiov1alpha1.RouteApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("RouteTCP"):
		return &traefikiov1alpha1.RouteTCPApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("RouteUDP"):
		return &traefikiov1alpha1.RouteUDPApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ServerHealthCheck"):
		return &traefikiov1alpha1.ServerHealthCheckApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ServersTransport"):
		return &traefikiov1alpha1.ServersTransportApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ServersTransportSpec"):
		return &traefikiov1alpha1.ServersTransportSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ServersTransportTCP"):
		return &traefikiov1alpha1.ServersTransportTCPApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ServersTransportTCPSpec"):
		return &traefikiov1alpha1.ServersTransportTCPSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("Service"):
		return &traefikiov1alpha1.ServiceApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ServiceTCP"):
		return &traefikiov1alpha1.ServiceTCPApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("ServiceUDP"):
		return &traefikiov1alpha1.ServiceUDPApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TLS"):
		return &traefikiov1alpha1.TLSApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TLSClientConfig"):
		return &traefikiov1alpha1.TLSClientConfigApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TLSOption"):
		return &traefikiov1alpha1.TLSOptionApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TLSOptionRef"):
		return &traefikiov1alpha1.TLSOptionRefApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TLSOptionSpec"):
		return &traefikiov1alpha1.TLSOptionSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TLSStore"):
		return &traefikiov1alpha1.TLSStoreApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TLSStoreRef"):
		return &traefikiov1alpha1.TLSStoreRefApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TLSStoreSpec"):
		return &traefikiov1alpha1.TLSStoreSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TLSTCP"):
		return &traefikiov1alpha1.TLSTCPApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TraefikService"):
		return &traefikiov1alpha1.TraefikServiceApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("TraefikServiceSpec"):
		return &traefikiov1alpha1.TraefikServiceSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("WeightedRoundRobin"):
		return &traefikiov1alpha1.WeightedRoundRobinApplyConfiguration{}

	}
	return nil
}

func NewTypeConverter(scheme *runtime.Scheme) managedfields.TypeConverter {
	return managedfields.NewSchemeTypeConverter(scheme, internal.Parser())
}
