;; Tests for f32x4 [ceil, floor, trunc, nearest] operations on major boundary values and all special values.


(module
  (func (export "f32x4.ceil") (param v128) (result v128) (f32x4.ceil (local.get 0)))
  (func (export "f32x4.floor") (param v128) (result v128) (f32x4.floor (local.get 0)))
  (func (export "f32x4.trunc") (param v128) (result v128) (f32x4.trunc (local.get 0)))
  (func (export "f32x4.nearest") (param v128) (result v128) (f32x4.nearest (local.get 0)))
)

(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.c000000000000p+2 0x1.c000000000000p+2 0x1.c000000000000p+2 0x1.c000000000000p+2))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.8000000000000p+2 -0x1.8000000000000p+2 -0x1.8000000000000p+2 -0x1.8000000000000p+2))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 123456790.0 123456790.0 123456790.0 123456790.0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 156374987062.0 156374987062.0 156374987062.0 156374987062.0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 156374987062.0 156374987062.0 156374987062.0 156374987062.0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 156374987062.0 156374987062.0 156374987062.0 156374987062.0))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.ceil" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                     (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                     (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                     (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                     (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                     (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                     (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                     (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                     (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                     (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                     (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                     (v128.const f32x4 0x1.8000000000000p+2 0x1.8000000000000p+2 0x1.8000000000000p+2 0x1.8000000000000p+2))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                     (v128.const f32x4 -0x1.c000000000000p+2 -0x1.c000000000000p+2 -0x1.c000000000000p+2 -0x1.c000000000000p+2))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                     (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                     (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 inf inf inf inf))
                                     (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 -inf -inf -inf -inf))
                                     (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                     (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                     (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                     (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                     (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                     (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                     (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                     (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                     (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                     (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                     (v128.const f32x4 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                     (v128.const f32x4 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                     (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                     (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                     (v128.const f32x4 156374987061.0 156374987061.0 156374987061.0 156374987061.0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                     (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                     (v128.const f32x4 156374987061.0 156374987061.0 156374987061.0 156374987061.0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                     (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                     (v128.const f32x4 156374987061.0 156374987061.0 156374987061.0 156374987061.0))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 nan nan nan nan))
                                     (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 -nan -nan -nan -nan))
                                     (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                     (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.floor" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                     (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                     (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                     (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                     (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                     (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                     (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                     (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                     (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                     (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                     (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                     (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                     (v128.const f32x4 0x1.8000000000000p+2 0x1.8000000000000p+2 0x1.8000000000000p+2 0x1.8000000000000p+2))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                     (v128.const f32x4 -0x1.8000000000000p+2 -0x1.8000000000000p+2 -0x1.8000000000000p+2 -0x1.8000000000000p+2))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                     (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                     (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 inf inf inf inf))
                                     (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 -inf -inf -inf -inf))
                                     (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                     (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                     (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                     (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                     (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                     (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                     (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                     (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                     (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                     (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                     (v128.const f32x4 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                     (v128.const f32x4 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                     (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                     (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                     (v128.const f32x4 156374987061.0 156374987061.0 156374987061.0 156374987061.0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                     (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                     (v128.const f32x4 156374987061.0 156374987061.0 156374987061.0 156374987061.0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                     (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                     (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                     (v128.const f32x4 156374987061.0 156374987061.0 156374987061.0 156374987061.0))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 nan nan nan nan))
                                     (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 -nan -nan -nan -nan))
                                     (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                     (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.trunc" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                     (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                       (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                       (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                       (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                       (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                       (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                       (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                       (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                       (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                       (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                       (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                       (v128.const f32x4 0x1.8000000000000p+2 0x1.8000000000000p+2 0x1.8000000000000p+2 0x1.8000000000000p+2))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                       (v128.const f32x4 -0x1.8000000000000p+2 -0x1.8000000000000p+2 -0x1.8000000000000p+2 -0x1.8000000000000p+2))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                       (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                       (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 inf inf inf inf))
                                       (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 -inf -inf -inf -inf))
                                       (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                       (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                       (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                       (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                       (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                       (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                       (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                       (v128.const f32x4 1.23456789e+27 1.23456789e+27 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                       (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                       (v128.const f32x4 123456789.0 123456789.0 123456789.0 123456789.0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                       (v128.const f32x4 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                       (v128.const f32x4 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                       (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                       (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                       (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                       (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                       (v128.const f32x4 156374987061.0 156374987061.0 156374987061.0 156374987061.0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                       (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                       (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                       (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                       (v128.const f32x4 156374987061.0 156374987061.0 156374987061.0 156374987061.0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                       (v128.const f32x4 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16 8.19855292164869e+16))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                       (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                       (v128.const f32x4 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22 4.298402914185348e+22))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                       (v128.const f32x4 156374987061.0 156374987061.0 156374987061.0 156374987061.0))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 nan nan nan nan))
                                       (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 -nan -nan -nan -nan))
                                       (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                       (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.nearest" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                       (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))


;; Unknown operators

(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.ceil (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.floor (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.trunc (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.nearest (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.ceil (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.floor (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.trunc (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.nearest (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.ceil (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.floor (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.trunc (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.nearest (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.ceil (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.floor (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.trunc (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.nearest (v128.const i32x4 0 0 0 0)))") "unknown operator")

;; type check
(assert_invalid (module (func (result v128) (f32x4.ceil (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.floor (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.trunc (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.nearest (i32.const 0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $f32x4.ceil-arg-empty (result v128)
      (f32x4.ceil)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.floor-arg-empty (result v128)
      (f32x4.floor)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.trunc-arg-empty (result v128)
      (f32x4.trunc)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.nearest-arg-empty (result v128)
      (f32x4.nearest)
    )
  )
  "type mismatch"
)

