;; This test tests that a blocked previous sync- or async-lifted callee
;; can be synchronously reentered by a sync-typed function without the
;; usual backpressure triggering. The $Tester component has two nested
;; components $C and $D, where $D imports and calls $C. $C contains utilities
;; used by $D to perform all the tests.
(component definition $Tester
  (component $C
    (core module $Memory (memory (export "mem") 1))
    (core instance $memory (instantiate $Memory))
    (core module $CM
      (import "" "mem" (memory 1))
      (import "" "task.return" (func $task.return (param i32)))
      (import "" "thread.yield" (func $thread.yield (result i32)))
      (import "" "waitable.join" (func $waitable.join (param i32 i32)))
      (import "" "waitable-set.new" (func $waitable-set.new (result i32)))
      (import "" "waitable-set.wait" (func $waitable-set.wait (param i32 i32) (result i32)))
      (import "" "future.new" (func $future.new (result i64)))
      (import "" "future.read" (func $future.read (param i32 i32) (result i32)))
      (import "" "future.write" (func $future.write (param i32 i32) (result i32)))

      (global $unblock-value (mut i32) (i32.const 0))

      ;; $ws is waited on by 'blocker' and added to by 'unblocker'
      (global $ws (mut i32) (i32.const 0))
      (func $start (global.set $ws (call $waitable-set.new)))
      (start $start)

      (func (export "blocker")
        ;; wait on $ws, which is initially empty, but will be populated with
        ;; a completed future when "unblocker" synchronously barges in.
        (local $ret i32)
        (local.set $ret (call $waitable-set.wait (global.get $ws) (i32.const 0)))
        (if (i32.ne (i32.const 4 (; FUTURE_READ ;)) (local.get $ret))
          (then unreachable))
        (if (i32.ne (i32.const 0 (; COMPLETED ;)) (i32.load (i32.const 4)))
          (then unreachable))

        (call $task.return (global.get $unblock-value))
      )

      (func (export "blocker-cb") (result i32)
        ;; wait on $ws, which is initially empty, but will be populated with
        ;; a completed future when "unblocker" synchronously barges in.
        (i32.or
          (i32.const 2 (; WAIT ;))
          (i32.shl (global.get $ws) (i32.const 4)))
      )
      (func (export "blocker-cb-cb") (param $event_code i32) (param $index i32) (param $payload i32) (result i32)
        (if (i32.ne (i32.const 4 (; FUTURE_READ ;)) (local.get $event_code))
          (then unreachable))
        (if (i32.ne (i32.const 0 (; COMPLETED ;)) (local.get $payload))
          (then unreachable))

        (call $task.return (global.get $unblock-value))
        (i32.const 0 (; EXIT ;))
      )

      (func $unblocker (export "unblocker") (param $val i32)
        (local $ret i32) (local $ret64 i64)
        (local $futr i32) (local $futw i32)

        ;; create read/write futures that will be used to unblock 'blocker'
        (local.set $ret64 (call $future.new))
        (local.set $futr (i32.wrap_i64 (local.get $ret64)))
        (local.set $futw (i32.wrap_i64 (i64.shr_u (local.get $ret64) (i64.const 32))))

        ;; perform a future.read which will block, and add this future to the waitable-set
        ;; being waited on by 'blocker'
        (local.set $ret (call $future.read (local.get $futr) (i32.const 0xdeadbeef)))
        (if (i32.ne (i32.const -1 (; BLOCKED ;)) (local.get $ret))
          (then unreachable))
        (call $waitable.join (local.get $futr) (global.get $ws))

        ;; perform a future.write which will rendezvous with the write and complete
        (local.set $ret (call $future.write (local.get $futw) (i32.const 0xdeadbeef)))
        (if (i32.ne (i32.const 0 (; COMPLETED ;)) (local.get $ret))
          (then unreachable))

        (global.set $unblock-value (local.get $val))
      )

      (func (export "yielder")
        (drop (call $thread.yield))
        (call $task.return (global.get $unblock-value))
      )
      (func (export "yielder-cb") (result i32)
        (i32.const 1 (; YIELD ;))
      )
      (func (export "yielder-cb-cb") (param $event_code i32) (param $index i32) (param $payload i32) (result i32)
        (if (i32.ne (i32.const 0 (; EVENT_NONE ;)) (local.get $event_code))
          (then unreachable))
        (if (i32.ne (i32.const 0) (local.get $index))
          (then unreachable))
        (if (i32.ne (i32.const 0) (local.get $payload))
          (then unreachable))
        (call $task.return (global.get $unblock-value))
        (i32.const 0 (; EXIT ;))
      )
      (func (export "poker") (param $val i32)
        (global.set $unblock-value (local.get $val))
      )
    )
    (type $FT (future))
    (canon task.return (result u32) (core func $task.return))
    (canon thread.yield (core func $thread.yield))
    (canon waitable.join (core func $waitable.join))
    (canon waitable-set.new (core func $waitable-set.new))
    (canon waitable-set.wait (memory $memory "mem") (core func $waitable-set.wait))
    (canon future.new $FT (core func $future.new))
    (canon future.read $FT async (core func $future.read))
    (canon future.write $FT async (core func $future.write))
    (core instance $cm (instantiate $CM (with "" (instance
      (export "mem" (memory $memory "mem"))
      (export "thread.yield" (func $thread.yield))
      (export "task.return" (func $task.return))
      (export "waitable.join" (func $waitable.join))
      (export "waitable-set.new" (func $waitable-set.new))
      (export "waitable-set.wait" (func $waitable-set.wait))
      (export "future.new" (func $future.new))
      (export "future.read" (func $future.read))
      (export "future.write" (func $future.write))
    ))))
    (type $R (resource (rep i32) (dtor (func $cm "unblocker"))))
    (type $S (resource (rep i32) (dtor (func $cm "poker"))))
    (canon resource.new $R (core func $new-R))
    (canon resource.new $S (core func $new-S))
    (export $R' "R" (type $R))
    (export $S' "S" (type $S))
    (func (export "new-R") (param "rep" u32) (result (own $R')) (canon lift (core func $new-R)))
    (func (export "blocker") async (result u32) (canon lift (core func $cm "blocker") async))
    (func (export "blocker-cb") async (result u32) (canon lift (core func $cm "blocker-cb") async (callback (func $cm "blocker-cb-cb"))))
    (func (export "unblocker") (param "val" u32) (canon lift (core func $cm "unblocker")))
    (func (export "new-S") (param "rep" u32) (result (own $S')) (canon lift (core func $new-S)))
    (func (export "yielder") async (result u32) (canon lift (core func $cm "yielder") async))
    (func (export "yielder-cb") async (result u32) (canon lift (core func $cm "yielder-cb") async (callback (func $cm "yielder-cb-cb"))))
    (func (export "poker") (param "val" u32) (canon lift (core func $cm "poker")))
  )
  (component $D
    (import "c" (instance $c
      (export "R" (type $R (sub resource)))
      (export "new-R" (func (param "rep" u32) (result (own $R))))
      (export "blocker" (func async (result u32)))
      (export "blocker-cb" (func async (result u32)))
      (export "unblocker" (func (param "val" u32)))
      (export "S" (type $S (sub resource)))
      (export "new-S" (func (param "rep" u32) (result (own $S))))
      (export "yielder" (func async (result u32)))
      (export "yielder-cb" (func async (result u32)))
      (export "poker" (func (param "val" u32)))
    ))

    (core module $Memory (memory (export "mem") 1))
    (core instance $memory (instantiate $Memory))
    (core module $Core
      (import "" "mem" (memory 1))
      (import "" "subtask.drop" (func $subtask.drop (param i32)))
      (import "" "waitable.join" (func $waitable.join (param i32 i32)))
      (import "" "waitable-set.new" (func $waitable-set.new (result i32)))
      (import "" "waitable-set.drop" (func $waitable-set.drop (param i32)))
      (import "" "waitable-set.wait" (func $waitable-set.wait (param i32 i32) (result i32)))
      (import "" "waitable-set.poll" (func $waitable-set.poll (param i32 i32) (result i32)))
      (import "" "new-R" (func $new-R (param i32) (result i32)))
      (import "" "drop-R" (func $drop-R (param i32)))
      (import "" "blocker" (func $blocker (param i32) (result i32)))
      (import "" "blocker-cb" (func $blocker-cb (param i32) (result i32)))
      (import "" "unblocker" (func $unblocker (param i32)))
      (import "" "new-S" (func $new-S (param i32) (result i32)))
      (import "" "drop-S" (func $drop-S (param i32)))
      (import "" "yielder" (func $yielder (param i32) (result i32)))
      (import "" "yielder-cb" (func $yielder-cb (param i32) (result i32)))
      (import "" "poker" (func $poker (param i32)))

      (func $wait-for-return (param $subtask i32) (param $retp i32) (param $expect i32)
        (local $outp i32)
        (local $ws i32) (local $event_code i32)

        (local.set $ws (call $waitable-set.new))
        (call $waitable.join (local.get $subtask) (local.get $ws))
        (local.set $outp (i32.const 32))
        (local.set $event_code (call $waitable-set.wait (local.get $ws) (local.get $outp)))
        (if (i32.ne (i32.const 1 (; SUBTASK ;)) (local.get $event_code))
          (then unreachable))
        (if (i32.ne (local.get $subtask) (i32.load (local.get $outp)))
          (then unreachable))
        (if (i32.ne (i32.const 2 (; RETURNED=2 ;)) (i32.load offset=4 (local.get $outp)))
          (then unreachable))
        (if (i32.ne (local.get $expect) (i32.load (local.get $retp)))
          (then unreachable))
        (call $subtask.drop (local.get $subtask))
        (call $waitable-set.drop (local.get $ws))
      )

      (func (export "run") (result i32)
        (local $ret i32) (local $retp i32)
        (local $subtask i32) (local $handle i32)

        (local.set $retp (i32.const 8))

        ;; call $blocker which will block during a synchronous function.
        ;; normally calling another function would hit backpressure until
        ;; $blocker was done, but calling the sync-typed function $unblocker
        ;; barges in synchronously.
        (local.set $ret (call $blocker (local.get $retp)))
        (if (i32.ne (i32.const 1 (; STARTED ;)) (i32.and (local.get $ret) (i32.const 0xf)))
          (then unreachable))
        (local.set $subtask (i32.shr_u (local.get $ret) (i32.const 4)))
        (call $unblocker (i32.const 90))
        (call $wait-for-return (local.get $subtask) (local.get $retp) (i32.const 90))

        ;; do it all again, but this time unblock via resource.drop:
        (local.set $handle (call $new-R (i32.const 91)))
        (local.set $ret (call $blocker (local.get $retp)))
        (if (i32.ne (i32.const 1 (; STARTED ;)) (i32.and (local.get $ret) (i32.const 0xf)))
          (then unreachable))
        (local.set $subtask (i32.shr_u (local.get $ret) (i32.const 4)))
        (call $drop-R (local.get $handle))
        (call $wait-for-return (local.get $subtask) (local.get $retp) (i32.const 91))

        ;; do both of the above again, but for $blocker-cb instead of $blocker
        (local.set $ret (call $blocker-cb (local.get $retp)))
        (if (i32.ne (i32.const 1 (; STARTED ;)) (i32.and (local.get $ret) (i32.const 0xf)))
          (then unreachable))
        (local.set $subtask (i32.shr_u (local.get $ret) (i32.const 4)))
        (call $unblocker (i32.const 92))
        (call $wait-for-return (local.get $subtask) (local.get $retp) (i32.const 92))
        (local.set $handle (call $new-R (i32.const 93)))
        (local.set $ret (call $blocker-cb (local.get $retp)))
        (if (i32.ne (i32.const 1 (; STARTED ;)) (i32.and (local.get $ret) (i32.const 0xf)))
          (then unreachable))
        (local.set $subtask (i32.shr_u (local.get $ret) (i32.const 4)))
        (call $drop-R (local.get $handle))
        (call $wait-for-return (local.get $subtask) (local.get $retp) (i32.const 93))

        ;; now do all the above again, but for 'yielder'/'yielder-cb', which
        ;; yield, instead of waiting, using 'poker' to deliver a specific value
        (local.set $ret (call $yielder (local.get $retp)))
        (if (i32.ne (i32.const 1 (; STARTED ;)) (i32.and (local.get $ret) (i32.const 0xf)))
          (then unreachable))
        (local.set $subtask (i32.shr_u (local.get $ret) (i32.const 4)))
        (call $poker (i32.const 94))
        (call $wait-for-return (local.get $subtask) (local.get $retp) (i32.const 94))
        (local.set $handle (call $new-S (i32.const 95)))
        (local.set $ret (call $yielder (local.get $retp)))
        (if (i32.ne (i32.const 1 (; STARTED ;)) (i32.and (local.get $ret) (i32.const 0xf)))
          (then unreachable))
        (local.set $subtask (i32.shr_u (local.get $ret) (i32.const 4)))
        (call $drop-S (local.get $handle))
        (call $wait-for-return (local.get $subtask) (local.get $retp) (i32.const 95))
        (local.set $ret (call $yielder-cb (local.get $retp)))
        (if (i32.ne (i32.const 1 (; STARTED ;)) (i32.and (local.get $ret) (i32.const 0xf)))
          (then unreachable))
        (local.set $subtask (i32.shr_u (local.get $ret) (i32.const 4)))
        (call $poker (i32.const 96))
        (call $wait-for-return (local.get $subtask) (local.get $retp) (i32.const 96))
        (local.set $handle (call $new-S (i32.const 97)))
        (local.set $ret (call $yielder-cb (local.get $retp)))
        (if (i32.ne (i32.const 1 (; STARTED ;)) (i32.and (local.get $ret) (i32.const 0xf)))
          (then unreachable))
        (local.set $subtask (i32.shr_u (local.get $ret) (i32.const 4)))
        (call $drop-S (local.get $handle))
        (call $wait-for-return (local.get $subtask) (local.get $retp) (i32.const 97))

        (i32.const 100)
      )
    )
    (alias export $c "R" (type $R))
    (alias export $c "S" (type $S))
    (canon resource.drop $R (core func $drop-R'))
    (canon resource.drop $S (core func $drop-S'))
    (canon subtask.drop (core func $subtask.drop))
    (canon waitable.join (core func $waitable.join))
    (canon waitable-set.new (core func $waitable-set.new))
    (canon waitable-set.drop (core func $waitable-set.drop))
    (canon waitable-set.wait (memory $memory "mem") (core func $waitable-set.wait))
    (canon waitable-set.poll (memory $memory "mem") (core func $waitable-set.poll))
    (canon lower (func $c "new-R") (core func $new-R'))
    (canon lower (func $c "blocker") (memory $memory "mem") async (core func $blocker'))
    (canon lower (func $c "blocker-cb") (memory $memory "mem") async (core func $blocker-cb'))
    (canon lower (func $c "unblocker") (core func $unblocker'))
    (canon lower (func $c "new-S") (core func $new-S'))
    (canon lower (func $c "yielder") (memory $memory "mem") async (core func $yielder'))
    (canon lower (func $c "yielder-cb") (memory $memory "mem") async (core func $yielder-cb'))
    (canon lower (func $c "poker") (core func $poker'))
    (core instance $core (instantiate $Core (with "" (instance
      (export "mem" (memory $memory "mem"))
      (export "subtask.drop" (func $subtask.drop))
      (export "waitable.join" (func $waitable.join))
      (export "waitable-set.new" (func $waitable-set.new))
      (export "waitable-set.drop" (func $waitable-set.drop))
      (export "waitable-set.wait" (func $waitable-set.wait))
      (export "waitable-set.poll" (func $waitable-set.poll))
      (export "new-R" (func $new-R'))
      (export "drop-R" (func $drop-R'))
      (export "blocker" (func $blocker'))
      (export "blocker-cb" (func $blocker-cb'))
      (export "unblocker" (func $unblocker'))
      (export "new-S" (func $new-S'))
      (export "drop-S" (func $drop-S'))
      (export "yielder" (func $yielder'))
      (export "yielder-cb" (func $yielder-cb'))
      (export "poker" (func $poker'))
    ))))
    (func (export "run") async (result u32) (canon lift (core func $core "run")))
  )
  (instance $c (instantiate $C))
  (instance $d (instantiate $D (with "c" (instance $c))))
  (func (export "run") (alias export $d "run"))
)

(component instance $i $Tester)
(assert_return (invoke "run") (u32.const 100))
