;; RUN: wast --assert default --snapshot tests/snapshots %

(assert_invalid
  (component (export "" (instance 0)))
  "index out of bounds")

(assert_invalid
  (component (export "" (component 0)))
  "index out of bounds")

(assert_invalid
  (component (export "" (core module 0)))
  "index out of bounds")

(assert_invalid
  (component (export "" (func 0)))
  "index out of bounds")

(component
  (component
    (import "a" (instance $i))
    (import "b" (core module $m))
    (import "c" (component $c))
    (import "e" (func $f))

    (export "f" (instance $i))
    (export "g" (core module $m))
    (export "h" (component $c))
    (export "j" (func $f))
  )
)

(component
  (component
    (import "a" (func))
    (export (interface "wasi:http/types@2.0.0") (func 0))
  )
)

;; import/exports can overlap on ids
(component
  (component
    (import (interface "wasi:http/types@2.0.0") (func))
    (export (interface "wasi:http/types@2.0.0") (func 0))
  )
)

;; cannot export some types of strings
(assert_invalid
  (component (type (component (export "integrity=<sha256-a>" (func)))))
  "not a valid export name")
(assert_invalid
  (component (type (component (export "url=<x>" (func)))))
  "not a valid export name")
(assert_invalid
  (component (type (component (export "relative-url=<x>" (func)))))
  "not a valid extern name")
(assert_invalid
  (component (type (component (export "locked-dep=<a:b>" (func)))))
  "not a valid export name")
(assert_invalid
  (component (type (component (export "unlocked-dep=<a:b>" (func)))))
  "not a valid export name")
