/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ga" locale.
 */
public class LocalizedNamesImpl_ga extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "ET",
        "AF",
        "ZA",
        "QO",
        "DZ",
        "AR",
        "AM",
        "AL",
        "AQ",
        "SA",
        "AZ",
        "AU",
        "BD",
        "BY",
        "BE",
        "BZ",
        "BA",
        "BO",
        "BW",
        "BR",
        "BG",
        "BI",
        "BT",
        "KH",
        "KZ",
        "KE",
        "CY",
        "KG",
        "KR",
        "KP",
        "CO",
        "XK",
        "HR",
        "CG",
        "CI",
        "DK",
        "AD",
        "EE",
        "EG",
        "CH",
        "ER",
        "FI",
        "FR",
        "AI",
        "GA",
        "GM",
        "DE",
        "GL",
        "GR",
        "GY",
        "GN",
        "GQ",
        "AO",
        "IQ",
        "IR",
        "IN",
        "ID",
        "IT",
        "JO",
        "NO",
        "IS",
        "NL",
        "BQ",
        "LV",
        "LR",
        "LY",
        "LB",
        "LT",
        "MK",
        "MY",
        "MW",
        "MR",
        "FM",
        "MD",
        "MN",
        "NA",
        "NG",
        "NE",
        "NC",
        "NZ",
        "AT",
        "PK",
        "DO",
        "PL",
        "PT",
        "GB",
        "RO",
        "RU",
        "EH",
        "ES",
        "TJ",
        "TZ",
        "EU",
        "TH",
        "TW",
        "AG",
        "ZM",
        "SV",
        "JP",
        "CZ",
        "SN",
        "RS",
        "GE",
        "GS",
        "CL",
        "CN",
        "ZW",
        "SY",
        "SI",
        "SK",
        "SO",
        "SE",
        "SZ",
        "SD",
        "SS",
        "TN",
        "TR",
        "TM",
        "UA",
        "UZ",
        "HU",
        "AE",
        "AW",
        "BH",
        "BB",
        "BJ",
        "BM",
        "BN",
        "BF",
        "CM",
        "QA",
        "VA",
        "CA",
        "EA",
        "KI",
        "CR",
        "TF",
        "IO",
        "KW",
        "CU",
        "CW",
        "DG",
        "DJ",
        "DM",
        "EC",
        "YE",
        "IE",
        "FJ",
        "GH",
        "GG",
        "JE",
        "GI",
        "GD",
        "GP",
        "GF",
        "GU",
        "GT",
        "GW",
        "HT",
        "HN",
        "JM",
        "IL",
        "LA",
        "LS",
        "LI",
        "EZ",
        "LU",
        "MG",
        "MM",
        "ML",
        "MT",
        "MA",
        "MQ",
        "YT",
        "MX",
        "MC",
        "ME",
        "MS",
        "MZ",
        "BS",
        "PS",
        "IC",
        "PH",
        "MP",
        "UN",
        "NR",
        "SC",
        "NP",
        "NI",
        "NU",
        "PG",
        "AX",
        "VG",
        "KY",
        "KM",
        "CC",
        "CK",
        "FK",
        "FO",
        "UM",
        "MH",
        "MV",
        "VI",
        "TC",
        "PW",
        "PN",
        "SB",
        "BV",
        "CP",
        "HM",
        "IM",
        "MU",
        "AC",
        "CX",
        "TT",
        "NF",
        "OM",
        "PA",
        "PY",
        "PE",
        "CD",
        "CF",
        "PF",
        "PR",
        "RE",
        "CV",
        "RW",
        "HK",
        "MO",
        "BL",
        "LC",
        "MF",
        "WS",
        "AS",
        "KN",
        "SH",
        "SM",
        "PM",
        "VC",
        "ST",
        "TD",
        "SL",
        "SG",
        "SX",
        "LK",
        "US",
        "SR",
        "SJ",
        "TL",
        "TK",
        "TG",
        "TO",
        "TA",
        "TV",
        "UG",
        "UY",
        "WF",
        "VU",
        "VE",
        "VN",
        "XA",
        "XB",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "an Domhan");
    namesMap.put("002", "an Afraic");
    namesMap.put("003", "Meiriceá Thuaidh");
    namesMap.put("005", "Meiriceá Theas");
    namesMap.put("009", "an Aigéine");
    namesMap.put("011", "Iarthar na hAfraice");
    namesMap.put("013", "Meiriceá Láir");
    namesMap.put("014", "Oirthear na hAfraice");
    namesMap.put("015", "Tuaisceart na hAfraice");
    namesMap.put("017", "an Afraic Láir");
    namesMap.put("018", "Deisceart na hAfraice");
    namesMap.put("019", "Críocha Mheiriceá");
    namesMap.put("021", "Tuaisceart Mheiriceá");
    namesMap.put("029", "an Mhuir Chairib");
    namesMap.put("030", "Oirthear na hÁise");
    namesMap.put("034", "Deisceart na hÁise");
    namesMap.put("035", "Oirdheisceart na hÁise");
    namesMap.put("039", "Deisceart na hEorpa");
    namesMap.put("053", "an Astraláise");
    namesMap.put("054", "an Mheilinéis");
    namesMap.put("057", "an Réigiún Micrinéiseach");
    namesMap.put("061", "an Pholainéis");
    namesMap.put("142", "an Áise");
    namesMap.put("143", "an Áise Láir");
    namesMap.put("145", "Iarthar na hÁise");
    namesMap.put("150", "an Eoraip");
    namesMap.put("151", "Oirthear na hEorpa");
    namesMap.put("154", "Tuaisceart na hEorpa");
    namesMap.put("155", "Iarthar na hEorpa");
    namesMap.put("202", "an Afraic fho-Shahárach");
    namesMap.put("419", "Meiriceá Laidineach");
    namesMap.put("AC", "Oileán na Deascabhála");
    namesMap.put("AD", "Andóra");
    namesMap.put("AE", "Aontas na nÉimíríochtaí Arabacha");
    namesMap.put("AF", "an Afganastáin");
    namesMap.put("AG", "Antigua agus Barbúda");
    namesMap.put("AI", "Angaíle");
    namesMap.put("AL", "an Albáin");
    namesMap.put("AM", "an Airméin");
    namesMap.put("AO", "Angóla");
    namesMap.put("AQ", "an Antartaice");
    namesMap.put("AR", "an Airgintín");
    namesMap.put("AS", "Samó Mheiriceá");
    namesMap.put("AT", "an Ostair");
    namesMap.put("AU", "an Astráil");
    namesMap.put("AW", "Arúba");
    namesMap.put("AX", "Oileáin Åland");
    namesMap.put("AZ", "an Asarbaiseáin");
    namesMap.put("BA", "an Bhoisnia agus an Heirseagaivéin");
    namesMap.put("BB", "Barbadós");
    namesMap.put("BD", "an Bhanglaidéis");
    namesMap.put("BE", "an Bheilg");
    namesMap.put("BF", "Buircíne Fasó");
    namesMap.put("BG", "an Bhulgáir");
    namesMap.put("BH", "Bairéin");
    namesMap.put("BI", "an Bhurúin");
    namesMap.put("BJ", "Beinin");
    namesMap.put("BL", "Saint Barthélemy");
    namesMap.put("BM", "Beirmiúda");
    namesMap.put("BN", "Brúiné");
    namesMap.put("BO", "an Bholaiv");
    namesMap.put("BQ", "an Ísiltír Chairibeach");
    namesMap.put("BR", "an Bhrasaíl");
    namesMap.put("BS", "na Bahámaí");
    namesMap.put("BT", "an Bhútáin");
    namesMap.put("BV", "Oileán Bouvet");
    namesMap.put("BW", "an Bhotsuáin");
    namesMap.put("BY", "an Bhealarúis");
    namesMap.put("BZ", "an Bheilís");
    namesMap.put("CA", "Ceanada");
    namesMap.put("CC", "Oileáin Cocos (Keeling)");
    namesMap.put("CD", "Poblacht Dhaonlathach an Chongó");
    namesMap.put("CF", "Poblacht na hAfraice Láir");
    namesMap.put("CG", "an Congó");
    namesMap.put("CH", "an Eilvéis");
    namesMap.put("CI", "an Cósta Eabhair");
    namesMap.put("CK", "Oileáin Cook");
    namesMap.put("CL", "an tSile");
    namesMap.put("CM", "Camarún");
    namesMap.put("CN", "an tSín");
    namesMap.put("CO", "an Cholóim");
    namesMap.put("CP", "Oileán Clipperton");
    namesMap.put("CR", "Cósta Ríce");
    namesMap.put("CU", "Cúba");
    namesMap.put("CV", "Rinn Verde");
    namesMap.put("CX", "Oileán na Nollag");
    namesMap.put("CY", "an Chipir");
    namesMap.put("CZ", "an tSeicia");
    namesMap.put("DE", "an Ghearmáin");
    namesMap.put("DK", "an Danmhairg");
    namesMap.put("DM", "Doiminice");
    namesMap.put("DO", "an Phoblacht Dhoiminiceach");
    namesMap.put("DZ", "an Ailgéir");
    namesMap.put("EA", "Ceuta agus Melilla");
    namesMap.put("EC", "Eacuadór");
    namesMap.put("EE", "an Eastóin");
    namesMap.put("EG", "an Éigipt");
    namesMap.put("EH", "an Sahára Thiar");
    namesMap.put("ER", "an Eiritré");
    namesMap.put("ES", "an Spáinn");
    namesMap.put("ET", "an Aetóip");
    namesMap.put("EU", "an tAontas Eorpach");
    namesMap.put("EZ", "Limistéar an euro");
    namesMap.put("FI", "an Fhionlainn");
    namesMap.put("FJ", "Fidsí");
    namesMap.put("FK", "Oileáin Fháclainne");
    namesMap.put("FM", "an Mhicrinéis");
    namesMap.put("FO", "Oileáin Fharó");
    namesMap.put("FR", "an Fhrainc");
    namesMap.put("GA", "an Ghabúin");
    namesMap.put("GB", "an Ríocht Aontaithe");
    namesMap.put("GD", "Greanáda");
    namesMap.put("GE", "an tSeoirsia");
    namesMap.put("GF", "Guáin na Fraince");
    namesMap.put("GG", "Geansaí");
    namesMap.put("GH", "Gána");
    namesMap.put("GI", "Giobráltar");
    namesMap.put("GL", "an Ghraonlainn");
    namesMap.put("GM", "an Ghaimbia");
    namesMap.put("GN", "an Ghuine");
    namesMap.put("GP", "Guadalúip");
    namesMap.put("GQ", "an Ghuine Mheánchiorclach");
    namesMap.put("GR", "an Ghréig");
    namesMap.put("GS", "an tSeoirsia Theas agus Oileáin Sandwich Theas");
    namesMap.put("GT", "Guatamala");
    namesMap.put("GW", "Guine Bissau");
    namesMap.put("GY", "an Ghuáin");
    namesMap.put("HK", "S.R.R. na Síne Hong Cong");
    namesMap.put("HM", "Oileán Heard agus Oileáin McDonald");
    namesMap.put("HN", "Hondúras");
    namesMap.put("HR", "an Chróit");
    namesMap.put("HT", "Háítí");
    namesMap.put("HU", "an Ungáir");
    namesMap.put("IC", "na hOileáin Chanáracha");
    namesMap.put("ID", "an Indinéis");
    namesMap.put("IE", "Éire");
    namesMap.put("IL", "Iosrael");
    namesMap.put("IM", "Oileán Mhanann");
    namesMap.put("IN", "an India");
    namesMap.put("IO", "Críoch Aigéan Indiach na Breataine");
    namesMap.put("IQ", "an Iaráic");
    namesMap.put("IR", "an Iaráin");
    namesMap.put("IS", "an Íoslainn");
    namesMap.put("IT", "an Iodáil");
    namesMap.put("JE", "Geirsí");
    namesMap.put("JM", "Iamáice");
    namesMap.put("JO", "an Iordáin");
    namesMap.put("JP", "an tSeapáin");
    namesMap.put("KE", "an Chéinia");
    namesMap.put("KG", "an Chirgeastáin");
    namesMap.put("KH", "an Chambóid");
    namesMap.put("KI", "Cireabaití");
    namesMap.put("KM", "Oileáin Chomóra");
    namesMap.put("KN", "San Críostóir-Nimheas");
    namesMap.put("KP", "an Chóiré Thuaidh");
    namesMap.put("KR", "an Chóiré Theas");
    namesMap.put("KW", "Cuáit");
    namesMap.put("KY", "Oileáin Cayman");
    namesMap.put("KZ", "an Chasacstáin");
    namesMap.put("LB", "an Liobáin");
    namesMap.put("LC", "Saint Lucia");
    namesMap.put("LI", "Lichtinstéin");
    namesMap.put("LK", "Srí Lanca");
    namesMap.put("LR", "an Libéir");
    namesMap.put("LS", "Leosóta");
    namesMap.put("LT", "an Liotuáin");
    namesMap.put("LU", "Lucsamburg");
    namesMap.put("LV", "an Laitvia");
    namesMap.put("LY", "an Libia");
    namesMap.put("MA", "Maracó");
    namesMap.put("MC", "Monacó");
    namesMap.put("MD", "an Mholdóiv");
    namesMap.put("ME", "Montainéagró");
    namesMap.put("MF", "Saint-Martin");
    namesMap.put("MH", "Oileáin Marshall");
    namesMap.put("MK", "an Mhacadóin");
    namesMap.put("ML", "Mailí");
    namesMap.put("MM", "Maenmar (Burma)");
    namesMap.put("MN", "an Mhongóil");
    namesMap.put("MO", "S.R.R. na Síne Macao");
    namesMap.put("MP", "na hOileáin Mháirianacha Thuaidh");
    namesMap.put("MR", "an Mháratáin");
    namesMap.put("MS", "Montsarat");
    namesMap.put("MT", "Málta");
    namesMap.put("MU", "Oileán Mhuirís");
    namesMap.put("MV", "Oileáin Mhaildíve");
    namesMap.put("MW", "an Mhaláiv");
    namesMap.put("MX", "Meicsiceo");
    namesMap.put("MY", "an Mhalaeisia");
    namesMap.put("MZ", "Mósaimbíc");
    namesMap.put("NA", "an Namaib");
    namesMap.put("NC", "an Nua-Chaladóin");
    namesMap.put("NE", "an Nígir");
    namesMap.put("NF", "Oileán Norfolk");
    namesMap.put("NG", "an Nigéir");
    namesMap.put("NI", "Nicearagua");
    namesMap.put("NL", "an Ísiltír");
    namesMap.put("NO", "an Iorua");
    namesMap.put("NP", "Neipeal");
    namesMap.put("NR", "Nárú");
    namesMap.put("NZ", "an Nua-Shéalainn");
    namesMap.put("OM", "Óman");
    namesMap.put("PE", "Peiriú");
    namesMap.put("PF", "Polainéis na Fraince");
    namesMap.put("PG", "Nua-Ghuine Phapua");
    namesMap.put("PH", "na hOileáin Fhilipíneacha");
    namesMap.put("PK", "an Phacastáin");
    namesMap.put("PL", "an Pholainn");
    namesMap.put("PM", "San Pierre agus Miquelon");
    namesMap.put("PN", "Oileáin Pitcairn");
    namesMap.put("PR", "Pórtó Ríce");
    namesMap.put("PS", "na Críocha Palaistíneacha");
    namesMap.put("PT", "an Phortaingéil");
    namesMap.put("PW", "Oileáin Palau");
    namesMap.put("PY", "Paragua");
    namesMap.put("QA", "Catar");
    namesMap.put("QO", "an Aigéine Imeallach");
    namesMap.put("RO", "an Rómáin");
    namesMap.put("RS", "an tSeirbia");
    namesMap.put("RU", "an Rúis");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "an Araib Shádach");
    namesMap.put("SB", "Oileáin Sholomón");
    namesMap.put("SC", "na Séiséil");
    namesMap.put("SD", "an tSúdáin");
    namesMap.put("SE", "an tSualainn");
    namesMap.put("SG", "Singeapór");
    namesMap.put("SH", "San Héilin");
    namesMap.put("SI", "an tSlóivéin");
    namesMap.put("SJ", "Svalbard agus Jan Mayen");
    namesMap.put("SK", "an tSlóvaic");
    namesMap.put("SL", "Siarra Leon");
    namesMap.put("SM", "San Mairíne");
    namesMap.put("SN", "an tSeineagáil");
    namesMap.put("SO", "an tSomáil");
    namesMap.put("SR", "Suranam");
    namesMap.put("SS", "an tSúdáin Theas");
    namesMap.put("ST", "São Tomé agus Príncipe");
    namesMap.put("SV", "an tSalvadóir");
    namesMap.put("SY", "an tSiria");
    namesMap.put("SZ", "an tSuasalainn");
    namesMap.put("TC", "Oileáin na dTurcach agus Caicos");
    namesMap.put("TD", "Sead");
    namesMap.put("TF", "Críocha Francacha Dheisceart an Domhain");
    namesMap.put("TG", "Tóga");
    namesMap.put("TH", "an Téalainn");
    namesMap.put("TJ", "an Táidsíceastáin");
    namesMap.put("TK", "Tócalá");
    namesMap.put("TL", "Tíomór Thoir");
    namesMap.put("TM", "an Tuircméanastáin");
    namesMap.put("TN", "an Túinéis");
    namesMap.put("TR", "an Tuirc");
    namesMap.put("TT", "Oileán na Tríonóide agus Tobága");
    namesMap.put("TW", "an Téaváin");
    namesMap.put("TZ", "an Tansáin");
    namesMap.put("UA", "an Úcráin");
    namesMap.put("UM", "Oileáin Imeallacha S.A.M.");
    namesMap.put("UN", "na Náisiúin Aontaiteh");
    namesMap.put("US", "Stáit Aontaithe Mheiriceá");
    namesMap.put("UY", "Uragua");
    namesMap.put("UZ", "an Úisbéiceastáin");
    namesMap.put("VA", "Cathair na Vatacáine");
    namesMap.put("VC", "San Uinseann agus na Greanáidíní");
    namesMap.put("VE", "Veiniséala");
    namesMap.put("VG", "Oileáin Bhriotanacha na Maighdean");
    namesMap.put("VI", "Oileáin Mheiriceánacha na Maighdean");
    namesMap.put("VN", "Vítneam");
    namesMap.put("VU", "Vanuatú");
    namesMap.put("WF", "Vailís agus Futúna");
    namesMap.put("WS", "Samó");
    namesMap.put("XK", "an Chosaiv");
    namesMap.put("YE", "Éimin");
    namesMap.put("ZA", "an Afraic Theas");
    namesMap.put("ZM", "an tSaimbia");
    namesMap.put("ZW", "an tSiombáib");
    namesMap.put("ZZ", "Réigiún Anaithnid");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "an Domhan",
        "002": "an Afraic",
        "003": "Meiriceá Thuaidh",
        "005": "Meiriceá Theas",
        "009": "an Aigéine",
        "011": "Iarthar na hAfraice",
        "013": "Meiriceá Láir",
        "014": "Oirthear na hAfraice",
        "015": "Tuaisceart na hAfraice",
        "017": "an Afraic Láir",
        "018": "Deisceart na hAfraice",
        "019": "Críocha Mheiriceá",
        "021": "Tuaisceart Mheiriceá",
        "029": "an Mhuir Chairib",
        "030": "Oirthear na hÁise",
        "034": "Deisceart na hÁise",
        "035": "Oirdheisceart na hÁise",
        "039": "Deisceart na hEorpa",
        "053": "an Astraláise",
        "054": "an Mheilinéis",
        "057": "an Réigiún Micrinéiseach",
        "061": "an Pholainéis",
        "142": "an Áise",
        "143": "an Áise Láir",
        "145": "Iarthar na hÁise",
        "150": "an Eoraip",
        "151": "Oirthear na hEorpa",
        "154": "Tuaisceart na hEorpa",
        "155": "Iarthar na hEorpa",
        "202": "an Afraic fho-Shahárach",
        "419": "Meiriceá Laidineach",
        "AC": "Oileán na Deascabhála",
        "AD": "Andóra",
        "AE": "Aontas na nÉimíríochtaí Arabacha",
        "AF": "an Afganastáin",
        "AG": "Antigua agus Barbúda",
        "AI": "Angaíle",
        "AL": "an Albáin",
        "AM": "an Airméin",
        "AO": "Angóla",
        "AQ": "an Antartaice",
        "AR": "an Airgintín",
        "AS": "Samó Mheiriceá",
        "AT": "an Ostair",
        "AU": "an Astráil",
        "AW": "Arúba",
        "AX": "Oileáin Åland",
        "AZ": "an Asarbaiseáin",
        "BA": "an Bhoisnia agus an Heirseagaivéin",
        "BB": "Barbadós",
        "BD": "an Bhanglaidéis",
        "BE": "an Bheilg",
        "BF": "Buircíne Fasó",
        "BG": "an Bhulgáir",
        "BH": "Bairéin",
        "BI": "an Bhurúin",
        "BJ": "Beinin",
        "BL": "Saint Barthélemy",
        "BM": "Beirmiúda",
        "BN": "Brúiné",
        "BO": "an Bholaiv",
        "BQ": "an Ísiltír Chairibeach",
        "BR": "an Bhrasaíl",
        "BS": "na Bahámaí",
        "BT": "an Bhútáin",
        "BV": "Oileán Bouvet",
        "BW": "an Bhotsuáin",
        "BY": "an Bhealarúis",
        "BZ": "an Bheilís",
        "CA": "Ceanada",
        "CC": "Oileáin Cocos (Keeling)",
        "CD": "Poblacht Dhaonlathach an Chongó",
        "CF": "Poblacht na hAfraice Láir",
        "CG": "an Congó",
        "CH": "an Eilvéis",
        "CI": "an Cósta Eabhair",
        "CK": "Oileáin Cook",
        "CL": "an tSile",
        "CM": "Camarún",
        "CN": "an tSín",
        "CO": "an Cholóim",
        "CP": "Oileán Clipperton",
        "CR": "Cósta Ríce",
        "CU": "Cúba",
        "CV": "Rinn Verde",
        "CX": "Oileán na Nollag",
        "CY": "an Chipir",
        "CZ": "an tSeicia",
        "DE": "an Ghearmáin",
        "DK": "an Danmhairg",
        "DM": "Doiminice",
        "DO": "an Phoblacht Dhoiminiceach",
        "DZ": "an Ailgéir",
        "EA": "Ceuta agus Melilla",
        "EC": "Eacuadór",
        "EE": "an Eastóin",
        "EG": "an Éigipt",
        "EH": "an Sahára Thiar",
        "ER": "an Eiritré",
        "ES": "an Spáinn",
        "ET": "an Aetóip",
        "EU": "an tAontas Eorpach",
        "EZ": "Limistéar an euro",
        "FI": "an Fhionlainn",
        "FJ": "Fidsí",
        "FK": "Oileáin Fháclainne",
        "FM": "an Mhicrinéis",
        "FO": "Oileáin Fharó",
        "FR": "an Fhrainc",
        "GA": "an Ghabúin",
        "GB": "an Ríocht Aontaithe",
        "GD": "Greanáda",
        "GE": "an tSeoirsia",
        "GF": "Guáin na Fraince",
        "GG": "Geansaí",
        "GH": "Gána",
        "GI": "Giobráltar",
        "GL": "an Ghraonlainn",
        "GM": "an Ghaimbia",
        "GN": "an Ghuine",
        "GP": "Guadalúip",
        "GQ": "an Ghuine Mheánchiorclach",
        "GR": "an Ghréig",
        "GS": "an tSeoirsia Theas agus Oileáin Sandwich Theas",
        "GT": "Guatamala",
        "GW": "Guine Bissau",
        "GY": "an Ghuáin",
        "HK": "S.R.R. na Síne Hong Cong",
        "HM": "Oileán Heard agus Oileáin McDonald",
        "HN": "Hondúras",
        "HR": "an Chróit",
        "HT": "Háítí",
        "HU": "an Ungáir",
        "IC": "na hOileáin Chanáracha",
        "ID": "an Indinéis",
        "IE": "Éire",
        "IL": "Iosrael",
        "IM": "Oileán Mhanann",
        "IN": "an India",
        "IO": "Críoch Aigéan Indiach na Breataine",
        "IQ": "an Iaráic",
        "IR": "an Iaráin",
        "IS": "an Íoslainn",
        "IT": "an Iodáil",
        "JE": "Geirsí",
        "JM": "Iamáice",
        "JO": "an Iordáin",
        "JP": "an tSeapáin",
        "KE": "an Chéinia",
        "KG": "an Chirgeastáin",
        "KH": "an Chambóid",
        "KI": "Cireabaití",
        "KM": "Oileáin Chomóra",
        "KN": "San Críostóir-Nimheas",
        "KP": "an Chóiré Thuaidh",
        "KR": "an Chóiré Theas",
        "KW": "Cuáit",
        "KY": "Oileáin Cayman",
        "KZ": "an Chasacstáin",
        "LB": "an Liobáin",
        "LC": "Saint Lucia",
        "LI": "Lichtinstéin",
        "LK": "Srí Lanca",
        "LR": "an Libéir",
        "LS": "Leosóta",
        "LT": "an Liotuáin",
        "LU": "Lucsamburg",
        "LV": "an Laitvia",
        "LY": "an Libia",
        "MA": "Maracó",
        "MC": "Monacó",
        "MD": "an Mholdóiv",
        "ME": "Montainéagró",
        "MF": "Saint-Martin",
        "MH": "Oileáin Marshall",
        "MK": "an Mhacadóin",
        "ML": "Mailí",
        "MM": "Maenmar (Burma)",
        "MN": "an Mhongóil",
        "MO": "S.R.R. na Síne Macao",
        "MP": "na hOileáin Mháirianacha Thuaidh",
        "MR": "an Mháratáin",
        "MS": "Montsarat",
        "MT": "Málta",
        "MU": "Oileán Mhuirís",
        "MV": "Oileáin Mhaildíve",
        "MW": "an Mhaláiv",
        "MX": "Meicsiceo",
        "MY": "an Mhalaeisia",
        "MZ": "Mósaimbíc",
        "NA": "an Namaib",
        "NC": "an Nua-Chaladóin",
        "NE": "an Nígir",
        "NF": "Oileán Norfolk",
        "NG": "an Nigéir",
        "NI": "Nicearagua",
        "NL": "an Ísiltír",
        "NO": "an Iorua",
        "NP": "Neipeal",
        "NR": "Nárú",
        "NZ": "an Nua-Shéalainn",
        "OM": "Óman",
        "PE": "Peiriú",
        "PF": "Polainéis na Fraince",
        "PG": "Nua-Ghuine Phapua",
        "PH": "na hOileáin Fhilipíneacha",
        "PK": "an Phacastáin",
        "PL": "an Pholainn",
        "PM": "San Pierre agus Miquelon",
        "PN": "Oileáin Pitcairn",
        "PR": "Pórtó Ríce",
        "PS": "na Críocha Palaistíneacha",
        "PT": "an Phortaingéil",
        "PW": "Oileáin Palau",
        "PY": "Paragua",
        "QA": "Catar",
        "QO": "an Aigéine Imeallach",
        "RO": "an Rómáin",
        "RS": "an tSeirbia",
        "RU": "an Rúis",
        "RW": "Ruanda",
        "SA": "an Araib Shádach",
        "SB": "Oileáin Sholomón",
        "SC": "na Séiséil",
        "SD": "an tSúdáin",
        "SE": "an tSualainn",
        "SG": "Singeapór",
        "SH": "San Héilin",
        "SI": "an tSlóivéin",
        "SJ": "Svalbard agus Jan Mayen",
        "SK": "an tSlóvaic",
        "SL": "Siarra Leon",
        "SM": "San Mairíne",
        "SN": "an tSeineagáil",
        "SO": "an tSomáil",
        "SR": "Suranam",
        "SS": "an tSúdáin Theas",
        "ST": "São Tomé agus Príncipe",
        "SV": "an tSalvadóir",
        "SY": "an tSiria",
        "SZ": "an tSuasalainn",
        "TC": "Oileáin na dTurcach agus Caicos",
        "TD": "Sead",
        "TF": "Críocha Francacha Dheisceart an Domhain",
        "TG": "Tóga",
        "TH": "an Téalainn",
        "TJ": "an Táidsíceastáin",
        "TK": "Tócalá",
        "TL": "Tíomór Thoir",
        "TM": "an Tuircméanastáin",
        "TN": "an Túinéis",
        "TR": "an Tuirc",
        "TT": "Oileán na Tríonóide agus Tobága",
        "TW": "an Téaváin",
        "TZ": "an Tansáin",
        "UA": "an Úcráin",
        "UM": "Oileáin Imeallacha S.A.M.",
        "UN": "na Náisiúin Aontaiteh",
        "US": "Stáit Aontaithe Mheiriceá",
        "UY": "Uragua",
        "UZ": "an Úisbéiceastáin",
        "VA": "Cathair na Vatacáine",
        "VC": "San Uinseann agus na Greanáidíní",
        "VE": "Veiniséala",
        "VG": "Oileáin Bhriotanacha na Maighdean",
        "VI": "Oileáin Mheiriceánacha na Maighdean",
        "VN": "Vítneam",
        "VU": "Vanuatú",
        "WF": "Vailís agus Futúna",
        "WS": "Samó",
        "XK": "an Chosaiv",
        "YE": "Éimin",
        "ZA": "an Afraic Theas",
        "ZM": "an tSaimbia",
        "ZW": "an tSiombáib",
        "ZZ": "Réigiún Anaithnid"
    };
  }-*/;
}
