/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSettingGui;
import org.openstreetmap.josm.gui.mappaint.loader.MapPaintStyleLoader;
import org.openstreetmap.josm.gui.util.StayOpenCheckBoxMenuItemUI;

public class BooleanStyleSettingGui
implements StyleSettingGui {
    final StyleSetting.BooleanStyleSetting setting;

    public BooleanStyleSettingGui(StyleSetting.BooleanStyleSetting setting) {
        this.setting = Objects.requireNonNull(setting);
    }

    @Override
    public void addMenuEntry(JMenu menu) {
        menu.add(new BooleanStyleSettingCheckBoxMenuItem(this.setting));
    }

    static class BooleanStyleSettingCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        boolean noRepaint;

        BooleanStyleSettingCheckBoxMenuItem(final StyleSetting.BooleanStyleSetting setting) {
            this.setAction(new AbstractAction(this, setting.label){
                final /* synthetic */ BooleanStyleSettingCheckBoxMenuItem this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    setting.setValue(this.this$0.isSelected());
                    if (!this.this$0.noRepaint) {
                        MainApplication.worker.submit(new MapPaintStyleLoader(Collections.singletonList(setting.parentStyle)));
                    }
                }
            });
            this.setSelected((Boolean)setting.getValue());
            this.setUI(new StayOpenCheckBoxMenuItemUI());
        }

        void doClickWithoutRepaint(int pressTime) {
            this.noRepaint = true;
            this.doClick(pressTime);
            this.noRepaint = false;
        }
    }
}

