/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.util.stream.Stream;
import org.openstreetmap.josm.data.oauth.OAuthVersion;

public interface IOAuthParameters {
    public String getAccessTokenUrl();

    public String getAuthorizationUrl();

    default public String getAuthorizationUrl(String state, Enum<?> ... scopes) {
        return this.getAuthorizationUrl(state, (String[])Stream.of(scopes).map(Enum::toString).toArray(String[]::new));
    }

    default public String getAuthorizationUrl(String state, String ... scopes) {
        return this.getAuthorizationUrl() + "?response_type=code&client_id=" + this.getClientId() + "&redirect_uri=" + this.getRedirectUri() + "&scope=" + String.join((CharSequence)" ", scopes) + "&state=" + state;
    }

    public OAuthVersion getOAuthVersion();

    public String getClientId();

    public String getClientSecret();

    default public String getRedirectUri() {
        return null;
    }

    default public String toPreferencesString() {
        return null;
    }

    default public String getApiUrl() {
        return null;
    }

    public void rememberPreferences();
}

