/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JTable;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.OsmIdSelectionDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class HistoryInfoAction
extends JosmAction {
    public static final Shortcut SHORTCUT = Shortcut.registerShortcut("core:historyinfo", I18n.tr("View: {0}", I18n.tr("History", new Object[0])), 72, 5006);

    public HistoryInfoAction() {
        super(I18n.tr("History", new Object[0]), "dialogs/history", I18n.tr("Display history information about OSM ways, nodes, or relations.", new Object[0]), SHORTCUT, true, "action/historyinfo", false);
        this.setHelpId(HelpUtil.ht("/Action/ObjectHistory"));
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Set<PrimitiveId> sel = new LinkedHashSet();
        if (ae.getSource() instanceof JTable) {
            JTable table = (JTable)ae.getSource();
            block0: for (int row : table.getSelectedRows()) {
                for (int col = 0; col < table.getModel().getColumnCount(); ++col) {
                    Object value = table.getModel().getValueAt(row, col);
                    if (!(value instanceof PrimitiveId)) continue;
                    sel.add((PrimitiveId)value);
                    continue block0;
                }
            }
        } else if (ae.getSource() instanceof JList) {
            JList list = (JList)ae.getSource();
            sel = list.getSelectedValuesList().stream().filter(v -> v instanceof PrimitiveId).map(v -> (PrimitiveId)v).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        if (!sel.isEmpty()) {
            HistoryBrowserDialogManager.getInstance().showHistory(sel);
            return;
        }
        OsmData<?, ?, ?, ?> set = this.getLayerManager().getActiveData();
        if (set != null && !set.selectionEmpty()) {
            HistoryBrowserDialogManager.getInstance().showHistory(set.getAllSelected());
        } else {
            HistoryObjectIDDialog dialog = new HistoryObjectIDDialog();
            if (dialog.showDialog().getValue() == dialog.getContinueButtonIndex()) {
                HistoryBrowserDialogManager.getInstance().showHistory(dialog.getOsmIds());
            }
        }
    }

    public static class HistoryObjectIDDialog
    extends OsmIdSelectionDialog {
        public HistoryObjectIDDialog() {
            super((Component)MainApplication.getMainFrame(), I18n.tr("Show history", new Object[0]), I18n.tr("Show history", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.setButtonIcons("dialogs/history", "cancel");
            this.init();
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            ((JButton)this.buttons.get(0)).setEnabled(!NetworkManager.isOffline(OnlineResource.OSM_API));
        }
    }
}

