/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryMessage;

public class DiscoveredService
implements Serializable {
    private static final long serialVersionUID = -7810164772089509751L;
    private ArrayList<String> cacheNames;
    private String serviceAddress;
    private int servicePort;
    private long lastHearFromTime;

    public DiscoveredService() {
    }

    public DiscoveredService(UDPDiscoveryMessage message) {
        this.setServiceAddress(message.getHost());
        this.setCacheNames(message.getCacheNames());
        this.setServicePort(message.getPort());
        this.setLastHearFromTime(System.currentTimeMillis());
    }

    public void setCacheNames(ArrayList<String> cacheNames) {
        this.cacheNames = cacheNames;
    }

    public ArrayList<String> getCacheNames() {
        return this.cacheNames;
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public void setLastHearFromTime(long lastHearFromTime) {
        this.lastHearFromTime = lastHearFromTime;
    }

    public long getLastHearFromTime() {
        return this.lastHearFromTime;
    }

    public int hashCode() {
        return Objects.hash(this.serviceAddress, this.servicePort);
    }

    public boolean equals(Object otherArg) {
        if (this == otherArg) {
            return true;
        }
        if (otherArg == null) {
            return false;
        }
        if (!(otherArg instanceof DiscoveredService)) {
            return false;
        }
        DiscoveredService other = (DiscoveredService)otherArg;
        if (!Objects.equals(this.serviceAddress, other.serviceAddress)) {
            return false;
        }
        return this.servicePort == other.servicePort;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n DiscoveredService");
        buf.append("\n CacheNames = [" + this.getCacheNames() + "]");
        buf.append("\n ServiceAddress = [" + this.getServiceAddress() + "]");
        buf.append("\n ServicePort = [" + this.getServicePort() + "]");
        buf.append("\n LastHearFromTime = [" + this.getLastHearFromTime() + "]");
        return buf.toString();
    }
}

