/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.Element;
import ch.poole.openinghoursparser.I18n;
import ch.poole.openinghoursparser.Util;
import ch.poole.openinghoursparser.VariableTime;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class TimeSpan
extends Element {
    private static final int HOURS_24 = 1440;
    public static final int UNDEFINED_TIME = Integer.MIN_VALUE;
    public static final int MIN_TIME = 0;
    public static final int MAX_TIME = 1440;
    public static final int MAX_EXTENDED_TIME = 2880;
    int start = Integer.MIN_VALUE;
    VariableTime startEvent = null;
    int end = Integer.MIN_VALUE;
    VariableTime endEvent = null;
    boolean openEnded = false;
    int interval = 0;

    public TimeSpan() {
    }

    public TimeSpan(@NotNull TimeSpan ts) {
        this.start = ts.start;
        this.startEvent = ts.startEvent != null ? ts.startEvent.copy() : null;
        this.end = ts.end;
        this.endEvent = ts.endEvent != null ? ts.endEvent.copy() : null;
        this.openEnded = ts.openEnded;
        this.interval = ts.interval;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.startEvent != null) {
            b.append(this.startEvent.toString());
        } else {
            this.appendTime(b, this.start);
        }
        if (this.endEvent != null) {
            b.append("-");
            b.append(this.endEvent.toString());
        } else if (this.end != Integer.MIN_VALUE) {
            b.append("-");
            int tempEnd = this.start != Integer.MIN_VALUE && this.end - this.start < 1440 && this.end > 1440 ? this.end - 1440 : this.end;
            this.appendTime(b, tempEnd);
        }
        if (this.openEnded) {
            b.append("+");
        }
        if (this.interval != 0) {
            b.append("/");
            this.appendTime(b, this.interval);
        }
        return b.toString();
    }

    private void appendTime(@NotNull StringBuilder b, int minutes) {
        b.append(String.format(Locale.US, "%02d", minutes / 60));
        b.append(":");
        b.append(String.format(Locale.US, "%02d", minutes % 60));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TimeSpan) {
            TimeSpan o = (TimeSpan)other;
            return this.start == o.start && Util.equals(this.startEvent, o.startEvent) && this.end == o.end && Util.equals(this.endEvent, o.endEvent) && this.openEnded == o.openEnded && this.interval == o.interval;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + this.start;
        result = 37 * result + (this.startEvent == null ? 0 : this.startEvent.hashCode());
        result = 37 * result + this.end;
        result = 37 * result + (this.endEvent == null ? 0 : this.endEvent.hashCode());
        result = 37 * result + (this.openEnded ? 0 : 1);
        result = 37 * result + this.interval;
        return result;
    }

    public int getStart() {
        return this.start;
    }

    public VariableTime getStartEvent() {
        return this.startEvent;
    }

    public int getEnd() {
        return this.end;
    }

    public VariableTime getEndEvent() {
        return this.endEvent;
    }

    public boolean isOpenEnded() {
        return this.openEnded;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setStart(int s) {
        if (this.invalidTime(s)) {
            throw new IllegalArgumentException(I18n.tr("invalid_time", s));
        }
        this.start = s;
    }

    private boolean invalidTime(int t) {
        return t != Integer.MIN_VALUE && (t < 0 || t > 2880);
    }

    public void setStartEvent(VariableTime startEvent) {
        this.startEvent = startEvent;
    }

    public void setEnd(int e) {
        if (this.invalidTime(e)) {
            throw new IllegalArgumentException(I18n.tr("invalid_time", e));
        }
        this.end = e;
    }

    public void setEndEvent(VariableTime endEvent) {
        this.endEvent = endEvent;
    }

    public void setOpenEnded(boolean openEnded) {
        this.openEnded = openEnded;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    @Override
    public TimeSpan copy() {
        return new TimeSpan(this);
    }
}

