/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import jline.console.completer.Completer;
import jline.console.completer.EnumCompleter;
import jline.console.completer.FileNameCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.basex.core.Text;
import org.basex.core.parse.Commands;
import org.basex.core.parse.PasswordReader;
import org.basex.util.Prop;
import org.basex.util.Reflect;
import org.basex.util.Util;

public abstract class ConsoleReader
implements AutoCloseable,
PasswordReader {
    private static final String PW_PROMPT = Text.PASSWORD + ": ";

    public abstract String readLine(String var1);

    @Override
    public abstract void close();

    public static ConsoleReader get() {
        if (Reflect.available("jline.console.ConsoleReader", new Object[0])) {
            try {
                return new JLineConsoleReader();
            }
            catch (IOException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }
        return new SimpleConsoleReader();
    }

    private static final class JLineConsoleReader
    extends ConsoleReader {
        private final jline.console.ConsoleReader reader;
        private final FileHistory history = new FileHistory(new File(Prop.HOMEDIR, ".basexhistory"));

        JLineConsoleReader() throws IOException {
            this.reader = new jline.console.ConsoleReader();
            this.reader.setHistory((History)this.history);
            this.reader.setHistoryEnabled(true);
            this.reader.setBellEnabled(false);
            this.reader.setExpandEvents(false);
            this.reader.addCompleter((Completer)new EnumCompleter(Commands.Cmd.class));
            this.reader.addCompleter((Completer)new FileNameCompleter());
        }

        @Override
        public String readLine(String prompt) {
            try {
                return this.reader.readLine(prompt);
            }
            catch (IOException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }

        @Override
        public String password() {
            try {
                return this.reader.readLine(PW_PROMPT, Character.valueOf('\u0000'));
            }
            catch (IOException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }

        @Override
        public void close() {
            try {
                this.history.flush();
            }
            catch (IOException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }
    }

    private static final class SimpleConsoleReader
    extends ConsoleReader {
        private final BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

        SimpleConsoleReader() {
        }

        @Override
        public String readLine(String prompt) {
            try {
                Util.print(prompt, new Object[0]);
                return this.in.readLine();
            }
            catch (IOException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }

        @Override
        public String password() {
            Util.print(PW_PROMPT, new Object[0]);
            return Util.password();
        }

        @Override
        public void close() {
        }
    }
}

