/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.util.regex.Pattern;
import org.basex.gui.text.SearchContext;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

final class ReplaceContext {
    private final String replace;
    byte[] text;

    ReplaceContext(String replace) {
        this.replace = replace;
    }

    int[] replace(SearchContext sc, byte[] txt, int start, int end) {
        int os = txt.length;
        if (sc.string.isEmpty()) {
            this.text = txt;
        } else {
            TokenBuilder tb = new TokenBuilder(os).add(txt, 0, start);
            if (sc.regex) {
                int flags = 32;
                if (!sc.mcase) {
                    flags |= 2;
                }
                Pattern pattern = Pattern.compile(sc.string, flags);
                if (sc.multi) {
                    tb.add(pattern.matcher(Token.string(txt, start, end)).replaceAll(this.replace));
                } else {
                    int s = start;
                    for (int e = start; e <= end; ++e) {
                        if (!(e < end ? txt[e] == 10 : e != s)) continue;
                        tb.add(pattern.matcher(Token.string(txt, s, e - s)).replaceAll(this.replace));
                        if (e < end) {
                            tb.add(10);
                        }
                        s = e + 1;
                    }
                }
            } else {
                byte[] srch = Token.token(sc.string);
                byte[] rplc = Token.token(this.replace);
                int ss = srch.length;
                boolean s = true;
                int s1 = start;
                int o = start;
                while (o < end) {
                    int sp;
                    if (o + ss <= end && s) {
                        if (sc.mcase) {
                            for (sp = 0; sp < ss && txt[o + sp] == srch[sp]; ++sp) {
                            }
                        } else {
                            while (sp < ss && Token.lc(Token.cp(txt, o + sp)) == Token.cp(srch, sp)) {
                                sp += Token.cl(srch, sp);
                            }
                        }
                    }
                    if (!(sp != ss || sc.word && o + ss != os && Character.isLetterOrDigit(Token.cp(txt, o + ss)))) {
                        tb.add(txt, s1, o).add(rplc);
                        s1 = o += ss;
                        s = !sc.word;
                        continue;
                    }
                    if (sc.word) {
                        s = !Character.isLetterOrDigit(Token.cp(txt, o));
                        o += Token.cl(txt, o);
                        continue;
                    }
                    ++o;
                }
                tb.add(txt, s1, end);
            }
            tb.add(txt, end, os);
            this.text = tb.finish();
        }
        return new int[]{start, end - os + this.text.length};
    }
}

