/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Functions;
import org.basex.query.func.StaticFunc;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.parse.FuncBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.QNm;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class StaticFuncCall
extends FuncCall {
    final QNm name;
    StaticFunc func;
    QNmMap<Expr> keywords;
    ParseExpr external;
    final boolean hasImport;

    public StaticFuncCall(QNm name, Expr[] args, QNmMap<Expr> keywords, InputInfo info, boolean hasImport) {
        this(name, args, (StaticFunc)null, info, hasImport);
        this.keywords = keywords;
    }

    private StaticFuncCall(QNm name, Expr[] args, StaticFunc func, InputInfo info, boolean hasImport) {
        super(info, args);
        this.name = name;
        this.func = func;
        this.hasImport = hasImport;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        Expr inlined;
        if (this.external != null) {
            return this.external.compile(cc);
        }
        super.compile(cc);
        this.func.compile(cc);
        if (!this.selfRecursive() && (inlined = this.func.inline(this.exprs, cc)) != null) {
            return inlined;
        }
        this.exprType.assign(this.func.seqType());
        return this;
    }

    private boolean selfRecursive() {
        ASTVisitor visitor = new ASTVisitor(){

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                return call.func != StaticFuncCall.this.func;
            }

            @Override
            public boolean inlineFunc(Scope scope) {
                return scope.visit(this);
            }

            @Override
            public boolean funcItem(FuncItem fi) {
                for (Expr expr : StaticFuncCall.this.exprs) {
                    if (expr != fi) continue;
                    return false;
                }
                return fi != StaticFuncCall.this.func.expr;
            }
        };
        for (Expr expr : this.exprs) {
            if (expr.accept(visitor)) continue;
            return true;
        }
        return !this.func.expr.accept(visitor);
    }

    @Override
    public StaticFuncCall optimize(CompileContext cc) {
        return this;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.evalFunc(this.func, qc);
    }

    @Override
    public StaticFuncCall copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new StaticFuncCall(this.name, StaticFuncCall.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), this.func, this.info, this.hasImport));
    }

    public void setFunc(StaticFunc sf) throws QueryException {
        this.func = sf;
        int arity = sf.arity();
        if (this.keywords != null) {
            QNm[] names = new QNm[arity];
            for (int n = 0; n < arity; ++n) {
                names[n] = sf.paramName(n);
            }
            this.exprs = Functions.prepareArgs(new FuncBuilder(this.info, this.exprs, this.keywords), names, this);
            this.keywords = null;
        }
        if (arity > this.exprs.length) {
            this.exprs = Arrays.copyOf(this.exprs, arity);
        }
        for (int a = arity - 1; a >= 0; --a) {
            if (this.exprs[a] != null) continue;
            Expr dflt = sf.defaults[a];
            if (dflt == null) {
                throw QueryError.ARGMISSING_X_X.get(this.info, this, sf.paramName(a).prefixString());
            }
            this.exprs[a] = dflt;
        }
        if (sf.anns.contains(Annotation.PRIVATE) && !sf.sc.baseURI().eq(this.sc().baseURI())) {
            throw QueryError.FUNCPRIVATE_X.get(this.info, new Object[]{this.name.string()});
        }
    }

    public int arity() {
        return this.exprs.length + (this.keywords != null ? this.keywords.size() : 0);
    }

    public void setExternal(ParseExpr ext) {
        this.external = ext;
    }

    public StaticFunc func() {
        return this.func;
    }

    @Override
    public boolean vacuous() {
        return this.func != null && this.func.vacuousBody() || this.external != null && this.external.vacuous();
    }

    @Override
    public boolean has(Flag ... flags) {
        if (this.external != null) {
            return this.external.has(flags);
        }
        if (super.has(flags)) {
            return true;
        }
        if (Flag.POS.oneOf(flags) || Flag.CTX.oneOf(flags)) {
            return false;
        }
        if (Flag.UPD.oneOf(flags) && this.func != null && this.func.updating()) {
            return true;
        }
        Flag[] flgs = Flag.remove(flags, Flag.UPD);
        return flgs.length != 0 && this.func != null && this.func.has(flgs);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.staticFuncCall(this) && super.accept(visitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof StaticFuncCall)) return false;
        StaticFuncCall call = (StaticFuncCall)obj;
        if (!this.name.eq(call.name)) return false;
        if (this.func != call.func) {
            if (this.external != call.external) return false;
        }
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public String description() {
        return "function";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name.string(), "tailCall", this.tco), this.exprs);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.name.prefixId()).params(this.exprs);
    }
}

