/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.basex.io.in.DataInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.GDt;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.Uln;
import org.basex.query.value.item.Uri;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.ChoiceItemType;
import org.basex.query.value.type.EnumType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.ByteList;
import org.basex.util.similarity.Levenshtein;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AtomType implements Type
{
    ITEM("item", null, Token.EMPTY, false, false, false, false, Type.ID.ITEM),
    UNTYPED("untyped", null, QueryText.XS_URI, false, false, false, false, Type.ID.UTY),
    ANY_TYPE("anyType", null, QueryText.XS_URI, false, false, false, false, Type.ID.ATY),
    ANY_SIMPLE_TYPE("anySimpleType", null, QueryText.XS_URI, false, false, false, false, Type.ID.AST),
    ANY_ATOMIC_TYPE("anyAtomicType", ITEM, QueryText.XS_URI, false, false, false, false, Type.ID.AAT),
    ERROR("error", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, false, Type.ID.ERR),
    UNTYPED_ATOMIC("untypedAtomic", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, true, false, true, Type.ID.ATM){

        @Override
        public Atm cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return Atm.get(item.string(info));
        }

        @Override
        public Atm cast(Object value, QueryContext qc, InputInfo info) {
            return Atm.get(Token.token(value));
        }

        @Override
        public Atm read(DataInput in, QueryContext qc) throws IOException {
            return Atm.get(in.readToken());
        }
    }
    ,
    STRING("string", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, true, true, Type.ID.STR){

        @Override
        public Str cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return Str.get(item.string(info));
        }

        @Override
        public Str cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return Str.get(value, qc, info);
        }

        @Override
        public Str read(DataInput in, QueryContext qc) throws IOException {
            return Str.get(in.readToken());
        }
    }
    ,
    NORMALIZED_STRING("normalizedString", STRING, QueryText.XS_URI, false, false, true, true, Type.ID.NST){

        @Override
        public Str cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            byte[] token = item.string(info);
            ByteList bl = new ByteList(token.length);
            for (int n : token) {
                bl.add(n == 9 || n == 13 || n == 10 ? 32 : n);
            }
            return Str.get(bl.finish(), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Str read(DataInput in, QueryContext qc) throws IOException {
            return Str.get(in.readToken(), this);
        }
    }
    ,
    TOKEN("token", NORMALIZED_STRING, QueryText.XS_URI, false, false, true, true, Type.ID.TOK){

        @Override
        public Str cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return Str.get(Token.normalize(item.string(info)), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Str read(DataInput in, QueryContext qc) throws IOException {
            return Str.get(in.readToken(), this);
        }
    }
    ,
    LANGUAGE("language", TOKEN, QueryText.XS_URI, false, false, true, true, Type.ID.LAN){

        @Override
        public Str cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            byte[] v = Token.normalize(item.string(info));
            if (!LANGPATTERN.matcher(Token.string(v)).matches()) {
                throw this.castError(item, info);
            }
            return Str.get(v, this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Str read(DataInput in, QueryContext qc) throws IOException {
            return Str.get(in.readToken(), this);
        }
    }
    ,
    NMTOKEN("NMTOKEN", TOKEN, QueryText.XS_URI, false, false, true, true, Type.ID.NMT){

        @Override
        public Str cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            byte[] v = Token.normalize(item.string(info));
            if (!XMLToken.isNMToken(v)) {
                throw this.castError(item, info);
            }
            return Str.get(v, this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Str read(DataInput in, QueryContext qc) throws IOException {
            return Str.get(in.readToken(), this);
        }
    }
    ,
    NAME("Name", TOKEN, QueryText.XS_URI, false, false, true, true, Type.ID.NAM){

        @Override
        public Str cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            byte[] v = Token.normalize(item.string(info));
            if (!XMLToken.isName(v)) {
                throw this.castError(item, info);
            }
            return Str.get(v, this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Str read(DataInput in, QueryContext qc) throws IOException {
            return Str.get(in.readToken(), this);
        }
    }
    ,
    NCNAME("NCName", NAME, QueryText.XS_URI, false, false, true, true, Type.ID.NCN){

        @Override
        public Str cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return Str.get(this.checkName(item, info), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Str read(DataInput in, QueryContext qc) throws IOException {
            return Str.get(in.readToken(), this);
        }
    }
    ,
    ID("ID", NCNAME, QueryText.XS_URI, false, false, true, true, Type.ID.ID){

        @Override
        public Str cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return Str.get(this.checkName(item, info), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Str read(DataInput in, QueryContext qc) throws IOException {
            return Str.get(in.readToken(), this);
        }
    }
    ,
    IDREF("IDREF", NCNAME, QueryText.XS_URI, false, false, true, true, Type.ID.IDR){

        @Override
        public Str cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return Str.get(this.checkName(item, info), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Str read(DataInput in, QueryContext qc) throws IOException {
            return Str.get(in.readToken(), this);
        }
    }
    ,
    ENTITY("ENTITY", NCNAME, QueryText.XS_URI, false, false, true, true, Type.ID.ENT){

        @Override
        public Str cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return Str.get(this.checkName(item, info), this);
        }

        @Override
        public Str cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Str read(DataInput in, QueryContext qc) throws IOException {
            return Str.get(in.readToken(), this);
        }
    }
    ,
    NUMERIC("numeric", ANY_ATOMIC_TYPE, QueryText.XS_URI, true, false, false, true, Type.ID.NUM){

        @Override
        public Item cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return item.type.isNumber() ? item : Dbl.get(this.checkNum(item, info).dbl(info));
        }

        @Override
        public Item cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }
    }
    ,
    FLOAT("float", NUMERIC, QueryText.XS_URI, true, false, false, true, Type.ID.FLT){

        @Override
        public Flt cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return Flt.get(this.checkNum(item, info).flt(info));
        }

        @Override
        public Flt cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Flt read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return Flt.get(Flt.parse(in.readToken(), null));
        }
    }
    ,
    DOUBLE("double", NUMERIC, QueryText.XS_URI, true, false, false, true, Type.ID.DBL){

        @Override
        public Dbl cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return Dbl.get(this.checkNum(item, info).dbl(info));
        }

        @Override
        public Dbl cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Dbl read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return Dbl.get(Dbl.parse(in.readToken(), null));
        }
    }
    ,
    DECIMAL("decimal", NUMERIC, QueryText.XS_URI, true, false, false, true, Type.ID.DEC){

        @Override
        public Dec cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return Dec.get(this.checkNum(item, info).dec(info));
        }

        @Override
        public Dec cast(Object value, QueryContext qc, InputInfo info) {
            BigDecimal bd;
            return Dec.get(value instanceof BigDecimal ? (bd = (BigDecimal)value) : new BigDecimal(Token.string(Token.token(value))));
        }

        @Override
        public Dec read(DataInput in, QueryContext qc) throws IOException {
            return Dec.get(new BigDecimal(Token.string(in.readToken())));
        }
    }
    ,
    PRECISION_DECIMAL("precisionDecimal", null, QueryText.XS_URI, true, false, false, true, Type.ID.PDC),
    INTEGER("integer", DECIMAL, QueryText.XS_URI, true, false, false, true, Type.ID.ITR){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return Itr.get(this.checkLong(value, 0L, 0L, info));
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong());
        }
    }
    ,
    NON_POSITIVE_INTEGER("nonPositiveInteger", INTEGER, QueryText.XS_URI, true, false, false, true, Type.ID.NPI){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, Long.MIN_VALUE, 0L, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    NEGATIVE_INTEGER("negativeInteger", NON_POSITIVE_INTEGER, QueryText.XS_URI, true, false, false, true, Type.ID.NIN){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, Long.MIN_VALUE, -1L, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    LONG("long", INTEGER, QueryText.XS_URI, true, false, false, true, Type.ID.LNG){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, 0L, 0L, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    INT("int", LONG, QueryText.XS_URI, true, false, false, true, Type.ID.INT){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, Integer.MIN_VALUE, Integer.MAX_VALUE, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    SHORT("short", INT, QueryText.XS_URI, true, false, false, true, Type.ID.SHR){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, -32768L, 32767L, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    BYTE("byte", SHORT, QueryText.XS_URI, true, false, false, true, Type.ID.BYT){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, -128L, 127L, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    NON_NEGATIVE_INTEGER("nonNegativeInteger", INTEGER, QueryText.XS_URI, true, false, false, true, Type.ID.NNI){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, 0L, Long.MAX_VALUE, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    UNSIGNED_LONG("unsignedLong", NON_NEGATIVE_INTEGER, QueryText.XS_URI, true, false, false, true, Type.ID.ULN){

        @Override
        public Uln cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Uln cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            Item item = this.checkNum(value, info);
            BigDecimal v = item.dec(info);
            BigDecimal i = v.setScale(0, RoundingMode.DOWN);
            if (v.signum() < 0 || v.compareTo(Uln.MAXULN) > 0 || item.type.isStringOrUntyped() && !v.equals(i)) {
                throw this.castError(item, info);
            }
            return new Uln(i.toBigInteger());
        }

        @Override
        public Uln read(DataInput in, QueryContext qc) throws IOException {
            return new Uln(new BigInteger(Token.string(in.readToken())));
        }
    }
    ,
    UNSIGNED_INT("unsignedInt", UNSIGNED_LONG, QueryText.XS_URI, true, false, false, true, Type.ID.UIN){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, 0L, 0xFFFFFFFFL, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    UNSIGNED_SHORT("unsignedShort", UNSIGNED_INT, QueryText.XS_URI, true, false, false, true, Type.ID.USH){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, 0L, 65535L, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    UNSIGNED_BYTE("unsignedByte", UNSIGNED_SHORT, QueryText.XS_URI, true, false, false, true, Type.ID.UBY){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, 0L, 255L, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    POSITIVE_INTEGER("positiveInteger", NON_NEGATIVE_INTEGER, QueryText.XS_URI, true, false, false, true, Type.ID.PIN){

        @Override
        public Itr cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast((Object)item, qc, info);
        }

        @Override
        public Itr cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return new Itr(this.checkLong(value, 1L, Long.MAX_VALUE, info), this);
        }

        @Override
        public Itr read(DataInput in, QueryContext qc) throws IOException {
            return Itr.get(in.readLong(), this);
        }
    }
    ,
    DURATION("duration", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.DUR){

        @Override
        public Dur cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item instanceof Dur) {
                Dur dur = (Dur)item;
                return new Dur(dur);
            }
            if (AtomType.isString(item)) {
                return new Dur(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Dur cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Dur read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new Dur(in.readToken(), null);
        }
    }
    ,
    YEAR_MONTH_DURATION("yearMonthDuration", DURATION, QueryText.XS_URI, false, false, false, true, Type.ID.YMD){

        @Override
        public YMDur cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item instanceof Dur) {
                Dur dur = (Dur)item;
                return new YMDur(dur);
            }
            if (AtomType.isString(item)) {
                return new YMDur(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public YMDur cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public YMDur read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new YMDur(in.readToken(), null);
        }
    }
    ,
    DAY_TIME_DURATION("dayTimeDuration", DURATION, QueryText.XS_URI, false, false, false, true, Type.ID.DTD){

        @Override
        public DTDur cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item instanceof Dur) {
                Dur dur = (Dur)item;
                return new DTDur(dur);
            }
            if (AtomType.isString(item)) {
                return new DTDur(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public DTDur cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public DTDur read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new DTDur(in.readToken(), null);
        }
    }
    ,
    DATE_TIME("dateTime", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.DTM){

        @Override
        public Dtm cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item.type.oneOf(DATE, DATE_TIME_STAMP)) {
                return new Dtm((ADate)item, (Type)DATE_TIME, info);
            }
            if (AtomType.isString(item)) {
                return new Dtm(item.string(info), (Type)DATE_TIME, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Dtm cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Dtm read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new Dtm(in.readToken(), (Type)DATE_TIME, null);
        }
    }
    ,
    DATE_TIME_STAMP("dateTimeStamp", DATE_TIME, QueryText.XS_URI, false, false, false, true, Type.ID.DTS){

        @Override
        public Dtm cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item.type.oneOf(DATE, DATE_TIME)) {
                return new Dtm((ADate)item, (Type)DATE_TIME_STAMP, info);
            }
            if (AtomType.isString(item)) {
                return new Dtm(item.string(info), (Type)DATE_TIME_STAMP, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Dtm cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Dtm read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new Dtm(in.readToken(), (Type)DATE_TIME_STAMP, null);
        }
    }
    ,
    DATE("date", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.DAT){

        @Override
        public Dat cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item.type.instanceOf(DATE_TIME)) {
                return new Dat((ADate)item);
            }
            if (AtomType.isString(item)) {
                return new Dat(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Dat cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Dat read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new Dat(in.readToken(), null);
        }
    }
    ,
    TIME("time", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.TIM){

        @Override
        public Tim cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item.type.instanceOf(DATE_TIME)) {
                return new Tim((ADate)item);
            }
            if (AtomType.isString(item)) {
                return new Tim(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Tim cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public Tim read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new Tim(in.readToken(), null);
        }
    }
    ,
    G_YEAR_MONTH("gYearMonth", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.YMO){

        @Override
        public GDt cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item.type.oneOf(DATE_TIME_STAMP, DATE_TIME, DATE)) {
                return new GDt((ADate)item, this);
            }
            if (AtomType.isString(item)) {
                return new GDt(item.string(info), this, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public GDt cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public GDt read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new GDt(in.readToken(), this, null);
        }
    }
    ,
    G_YEAR("gYear", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.YEA){

        @Override
        public GDt cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item.type.oneOf(DATE_TIME_STAMP, DATE_TIME, DATE)) {
                return new GDt((ADate)item, this);
            }
            if (AtomType.isString(item)) {
                return new GDt(item.string(info), this, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public GDt cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public GDt read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new GDt(in.readToken(), this, null);
        }
    }
    ,
    G_MONTH_DAY("gMonthDay", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.MDA){

        @Override
        public GDt cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item.type.oneOf(DATE_TIME_STAMP, DATE_TIME, DATE)) {
                return new GDt((ADate)item, this);
            }
            if (AtomType.isString(item)) {
                return new GDt(item.string(info), this, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public GDt cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public GDt read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new GDt(in.readToken(), this, null);
        }
    }
    ,
    G_DAY("gDay", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.DAY){

        @Override
        public GDt cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item.type.oneOf(DATE_TIME_STAMP, DATE_TIME, DATE)) {
                return new GDt((ADate)item, this);
            }
            if (AtomType.isString(item)) {
                return new GDt(item.string(info), this, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public GDt cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public GDt read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new GDt(in.readToken(), this, null);
        }
    }
    ,
    G_MONTH("gMonth", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.MON){

        @Override
        public GDt cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item.type.oneOf(DATE_TIME_STAMP, DATE_TIME, DATE)) {
                return new GDt((ADate)item, this);
            }
            if (AtomType.isString(item)) {
                return new GDt(item.string(info), this, info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public GDt cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            return this.cast(Str.get(value, qc, info), qc, info);
        }

        @Override
        public GDt read(DataInput in, QueryContext qc) throws IOException, QueryException {
            return new GDt(in.readToken(), this, null);
        }
    }
    ,
    BOOLEAN("boolean", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.BLN){

        @Override
        public Bln cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item instanceof ANum) {
                return Bln.get(item.bool(info));
            }
            if (AtomType.isString(item)) {
                return Bln.get(Bln.parse(item, info));
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Bln cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            Bln bln;
            if (value instanceof Boolean) {
                Boolean bln2 = (Boolean)value;
                bln = Bln.get(bln2);
            } else {
                bln = this.cast(Str.get(value, qc, info), qc, info);
            }
            return bln;
        }

        @Override
        public Bln read(DataInput in, QueryContext qc) throws IOException {
            return Bln.get(in.readBool());
        }
    }
    ,
    BINARY("binary", ANY_ATOMIC_TYPE, QueryText.BASEX_URI, false, false, false, true, Type.ID.BIN),
    BASE64_BINARY("base64Binary", BINARY, QueryText.XS_URI, false, false, false, true, Type.ID.B64){

        @Override
        public B64 cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item instanceof Bin) {
                Bin bin = (Bin)item;
                return B64.get(bin, info);
            }
            if (AtomType.isString(item)) {
                return B64.get(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public B64 cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            B64 b64;
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                b64 = B64.get(bytes);
            } else {
                b64 = B64.get(Token.token(value), info);
            }
            return b64;
        }

        @Override
        public B64 read(DataInput in, QueryContext qc) throws IOException {
            return B64.get(in.readToken());
        }
    }
    ,
    HEX_BINARY("hexBinary", BINARY, QueryText.XS_URI, false, false, false, true, Type.ID.HEX){

        @Override
        public Hex cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (item instanceof Bin) {
                Bin bin = (Bin)item;
                return new Hex(bin, info);
            }
            if (AtomType.isString(item)) {
                return new Hex(item.string(info), info);
            }
            throw QueryError.typeError(item, this, info);
        }

        @Override
        public Hex cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
            byte[] byArray;
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                byArray = bytes;
            } else {
                byArray = Token.token(value);
            }
            return new Hex(byArray, info);
        }

        @Override
        public Hex read(DataInput in, QueryContext qc) throws IOException {
            return new Hex(in.readToken());
        }
    }
    ,
    ANY_URI("anyURI", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, true, true, Type.ID.URI){

        @Override
        public Uri cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            if (!item.type.isStringOrUntyped()) {
                throw QueryError.typeError(item, this, info);
            }
            Uri u = Uri.get(item.string(info));
            if (!u.isValid()) {
                throw this.castError(item, info);
            }
            return u;
        }

        @Override
        public Uri cast(Object value, QueryContext qc, InputInfo info) {
            return Uri.get(Token.token(value));
        }

        @Override
        public Uri read(DataInput in, QueryContext qc) throws IOException {
            return Uri.get(in.readToken());
        }
    }
    ,
    QNAME("QName", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, true, Type.ID.QNM){

        @Override
        public QNm cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
            Type type = item.type;
            if (type != STRING && !type.isUntyped()) {
                throw QueryError.typeError(item, this, info);
            }
            byte[] name = Token.trim(item.string(info));
            if (XMLToken.isQName(name)) {
                QNm qnm = qc.shared.qName(name, info.sc().ns.uri(Token.prefix(name)));
                if (!qnm.hasURI() && qnm.hasPrefix()) {
                    throw QueryError.NSDECL_X.get(info, new Object[]{qnm.prefix()});
                }
                return qnm;
            }
            throw this.castError(item, info);
        }

        @Override
        public QNm cast(Object value, QueryContext qc, InputInfo info) {
            QNm qNm;
            if (value instanceof QName) {
                QName name = (QName)value;
                qNm = new QNm(name);
            } else {
                qNm = new QNm(value.toString().replaceAll("^#", ""));
            }
            return qNm;
        }

        @Override
        public QNm read(DataInput in, QueryContext qc) throws IOException {
            return new QNm(in.readToken(), in.readBool() ? in.readToken() : null);
        }
    }
    ,
    NOTATION("NOTATION", ANY_ATOMIC_TYPE, QueryText.XS_URI, false, false, false, false, Type.ID.NOT);

    private static final Pattern LANGPATTERN;
    private final byte[] name;
    private final AtomType parent;
    private final byte[] uri;
    private final Type.ID id;
    private final boolean numeric;
    private final boolean untyped;
    private final boolean string;
    private final boolean sortable;
    private short prePost;
    private EnumMap<Occ, SeqType> seqTypes;
    private QNm qnm;

    private AtomType(String name, AtomType parent, byte[] uri, boolean numeric, boolean untyped, boolean string2, boolean sortable, Type.ID id) {
        this.name = Token.token(name);
        this.parent = parent;
        this.uri = uri;
        this.numeric = numeric;
        this.untyped = untyped;
        this.string = string2;
        this.sortable = sortable;
        this.id = id;
    }

    private void assign(EnumMap<AtomType, List<AtomType>> types, byte[] pp) {
        byte by = pp[0];
        pp[0] = (byte)(by + 1);
        this.prePost = by;
        for (AtomType type : types.getOrDefault(this, List.of())) {
            type.assign(types, pp);
        }
        byte by2 = pp[1];
        pp[1] = (byte)(by2 + 1);
        this.prePost = (short)(this.prePost | by2 << 8);
    }

    @Override
    public Item cast(Item item, QueryContext qc, InputInfo info) throws QueryException {
        if (item.type == this) {
            return item;
        }
        throw QueryError.typeError(item, this, info);
    }

    @Override
    public Item cast(Object value, QueryContext qc, InputInfo info) throws QueryException {
        throw QueryError.FUNCCAST_X_X.get(info, this, value);
    }

    @Override
    public Item read(DataInput in, QueryContext qc) throws IOException, QueryException {
        throw Util.notExpected();
    }

    @Override
    public final SeqType seqType(Occ occ) {
        if (this.seqTypes == null) {
            this.seqTypes = new EnumMap(Occ.class);
        }
        return this.seqTypes.computeIfAbsent(occ, o -> new SeqType(this, (Occ)((Object)o)));
    }

    public final QNm qname() {
        if (this.qnm == null) {
            this.qnm = new QNm(this.name, this.uri);
        }
        return this.qnm;
    }

    public final AtomType parent() {
        return this.parent;
    }

    @Override
    public final boolean eq(Type type) {
        return this == type;
    }

    @Override
    public final boolean instanceOf(Type type) {
        ChoiceItemType cit;
        if (type == this || type == ITEM) {
            return true;
        }
        if (type instanceof AtomType) {
            AtomType at = (AtomType)type;
            return (this.prePost & 0xFF) >= (at.prePost & 0xFF) && (this.prePost & 0xFF00) <= (at.prePost & 0xFF00);
        }
        return type instanceof ChoiceItemType && (cit = (ChoiceItemType)type).hasInstance(this);
    }

    @Override
    public final Type union(Type type) {
        if (this == ERROR) {
            return type;
        }
        if (type == ERROR) {
            return this;
        }
        if (type instanceof ChoiceItemType || type instanceof EnumType) {
            return type.union(this);
        }
        if (this.instanceOf(type)) {
            return type;
        }
        if (type.instanceOf(this)) {
            return this;
        }
        if (type instanceof AtomType) {
            AtomType at = (AtomType)type;
            ArrayList<AtomType> ancestors = new ArrayList<AtomType>(8);
            AtomType p = at;
            while (p != null) {
                ancestors.add(p);
                p = p.parent;
            }
            p = this;
            while (p != null) {
                if (ancestors.contains(p)) {
                    return p;
                }
                p = p.parent;
            }
        }
        return ITEM;
    }

    @Override
    public final Type intersect(Type type) {
        if (this == ERROR) {
            return type;
        }
        if (type == ERROR) {
            return this;
        }
        return type instanceof ChoiceItemType ? type.intersect(this) : (this.instanceOf(type) ? this : (type.instanceOf(this) ? type : null));
    }

    @Override
    public final boolean isNumber() {
        return this.numeric;
    }

    @Override
    public final boolean isUntyped() {
        return this.untyped;
    }

    @Override
    public final boolean isNumberOrUntyped() {
        return this.numeric || this.untyped;
    }

    @Override
    public final boolean isStringOrUntyped() {
        return this.string || this.untyped;
    }

    @Override
    public final boolean isSortable() {
        return this.sortable;
    }

    @Override
    public final AtomType atomic() {
        return this.instanceOf(ANY_ATOMIC_TYPE) ? this : null;
    }

    @Override
    public final Type.ID id() {
        return this.id;
    }

    final Item checkNum(Item item, InputInfo info) throws QueryException {
        Type type = item.type;
        if (item instanceof ANum || type.isStringOrUntyped() && type != ANY_URI || type == BOOLEAN) {
            return item;
        }
        throw QueryError.typeError(item, this, info);
    }

    final long checkLong(Object value, long min, long max, InputInfo info) throws QueryException {
        Item item = this.checkNum(value, info);
        Type type = item.type;
        if (type.oneOf(DOUBLE, FLOAT)) {
            double d = item.dbl(info);
            if (!Double.isFinite(d)) {
                throw QueryError.valueError(this, item.string(info), info);
            }
            if (min != max && (d < (double)min || d > (double)max)) {
                throw this.castError(item, info);
            }
            if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
                throw QueryError.INTRANGE_X.get(info, d);
            }
            return (long)d;
        }
        long l = item.itr(info);
        if (min != max && (l < min || l > max)) {
            throw this.castError(item, info);
        }
        return l;
    }

    final Item checkNum(Object value, InputInfo info) throws QueryException {
        Item item;
        if (value instanceof Value) {
            Value val = (Value)value;
            if (val.size() != 1L) {
                throw QueryError.typeError(val, this, info);
            }
            item = (Item)val;
        } else {
            item = value instanceof Double || value instanceof Float ? Dbl.get(((Number)value).doubleValue()) : (value instanceof Number ? Itr.get(((Number)value).longValue()) : (value instanceof Character ? Itr.get(((Character)value).charValue()) : Str.get(Token.token(value))));
        }
        return this.checkNum(item, info);
    }

    final byte[] checkName(Item item, InputInfo info) throws QueryException {
        byte[] v = Token.normalize(item.string(info));
        if (!XMLToken.isNCName(v)) {
            throw this.castError(item, info);
        }
        return v;
    }

    public final QueryException castError(Item item, InputInfo info) {
        return QueryError.FUNCCAST_X_X_X.get(info, item.type, this, item);
    }

    public final QueryException castError(byte[] value, InputInfo info) {
        return QueryError.FUNCCAST_X_X.get(info, this, value);
    }

    @Override
    public final boolean nsSensitive() {
        return this.eq(QNAME) || this.eq(NOTATION);
    }

    @Override
    public final boolean refinable() {
        return !((Checks<AtomType>)at -> at.eq(this) || !at.instanceOf(this)).all((AtomType[])AtomType.values());
    }

    @Override
    public final String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (Token.eq(QueryText.XS_URI, this.uri)) {
            tb.add(QueryText.XS_PREFIX).add(58).add(this.name);
        } else {
            tb.add(this.name).add("()");
        }
        return tb.toString();
    }

    public static AtomType find(QNm qname, boolean all) {
        if (!Token.eq(qname.uri(), QueryText.BASEX_URI)) {
            for (AtomType value : AtomType.values()) {
                if (!qname.eq(value.qname()) || !all && value.parent == null) continue;
                return value;
            }
        }
        return null;
    }

    public static String similar(QNm qname) {
        byte[] ln = Token.lc(qname.local());
        Function<AtomType, byte[]> local = tp -> {
            QNm qnm = tp.qname();
            return Token.eq(qnm.uri(), QueryText.XS_URI) && tp.parent != null ? qnm.local() : null;
        };
        Object similar = Levenshtein.similar(ln, AtomType.values(), value -> local.apply((AtomType)value));
        if (similar == null) {
            for (AtomType value2 : AtomType.values()) {
                byte[] lc = local.apply(value2);
                if (lc == null || !Token.startsWith(lc, ln)) continue;
                similar = value2;
                break;
            }
        }
        return QueryError.similar(qname.prefixId(Token.XML), similar);
    }

    private static boolean isString(Item item) {
        Type type = item.type;
        return type.isStringOrUntyped() && type != ANY_URI;
    }

    static {
        LANGPATTERN = Pattern.compile("[A-Za-z]{1,8}(-[A-Za-z\\d]{1,8})*");
        EnumMap<AtomType, List<AtomType>> types = new EnumMap<AtomType, List<AtomType>>(AtomType.class);
        for (AtomType type : AtomType.values()) {
            if (type.parent == null) continue;
            types.computeIfAbsent(type.parent, k -> new ArrayList()).add(type);
        }
        ITEM.assign(types, new byte[2]);
    }
}

