/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import de.bottlecaps.markup.Blitz;
import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.codepoints.Range;
import de.bottlecaps.markup.blitz.codepoints.RangeSet;
import de.bottlecaps.markup.blitz.grammar.Alt;
import de.bottlecaps.markup.blitz.grammar.Charset;
import de.bottlecaps.markup.blitz.grammar.Grammar;
import de.bottlecaps.markup.blitz.grammar.Ixml;
import de.bottlecaps.markup.blitz.grammar.Literal;
import de.bottlecaps.markup.blitz.grammar.Nonterminal;
import de.bottlecaps.markup.blitz.grammar.Rule;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.BNF;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ToREx
extends Visitor {
    private final String padding = "                ";
    private StringBuilder sb = new StringBuilder();
    private Map<String, String> charsets = new LinkedHashMap<String, String>();
    private Grammar grammar;

    private ToREx() {
    }

    public static String process(Grammar g) {
        ToREx toREx = new ToREx();
        toREx.grammar = g;
        toREx.visit(Charset.END);
        toREx.sb.setLength(0);
        toREx.visit(g);
        if (!toREx.charsets.isEmpty()) {
            toREx.sb.append("\n\n<?TOKENS?>\n");
            toREx.charsets.values().forEach(toREx.sb::append);
        }
        return toREx.sb.toString();
    }

    @Override
    public void visit(Rule r) {
        Rule firstRule = r.getGrammar().getRules().values().iterator().next();
        Charset singleCharset = ToREx.singleCharset(r);
        if (singleCharset != null && !ToREx.isSingleAscii(singleCharset)) {
            super.visit(r);
        } else {
            if (r != firstRule) {
                this.sb.append("\n");
            }
            String name = r.getName();
            this.sb.append(name);
            int paddingLength = "                ".length() - name.length() - 2;
            if (paddingLength < 1) {
                this.sb.append("\n");
                paddingLength = "                ".length() - 2;
            }
            this.sb.append("                ".substring(0, paddingLength));
            this.sb.append("::=");
            super.visit(r);
            if (r == firstRule) {
                this.sb.append(" ").append(this.grammar.getAdditionalNames().get(Charset.END)[0]);
            }
        }
    }

    @Override
    public void visit(Alt a) {
        if (a != a.getRule().getAlts().getAlts().iterator().next()) {
            this.sb.append("\n").append("                ").append("|");
        }
        super.visit(a);
    }

    @Override
    public void visit(Charset c) {
        if (ToREx.isSingleAscii(c)) {
            this.sb.append(" ");
            this.sb.append(c.getRangeSet().iterator().next().toREx());
        } else {
            String[] name = this.grammar.getAdditionalNames().get(c);
            if (c.getRule() == null || !name[0].equals(c.getRule().getName())) {
                this.sb.append(" ");
                this.sb.append(name[0]);
            }
            if (!this.charsets.containsKey(name[0])) {
                StringBuilder tb = new StringBuilder("\n").append(name[0]);
                int paddingLength = "                ".length() - name[0].length() - 2;
                if (paddingLength < 1) {
                    tb.append("\n");
                    paddingLength = "                ".length() - 2;
                }
                tb.append("                ".substring(0, paddingLength));
                tb.append("::= ");
                if (c == Charset.END) {
                    tb.append("$");
                } else {
                    tb.append(c.getRangeSet().stream().map(Range::toREx).collect(Collectors.joining("\n                | ")));
                }
                this.charsets.put(name[0], tb.toString());
            }
        }
    }

    private static Charset singleCharset(Rule r) {
        Term term;
        List<Term> terms;
        List<Alt> alts = r.getAlts().getAlts();
        if (alts.size() == 1 && (terms = alts.get(0).getTerms()).size() == 1 && (term = terms.get(0)) instanceof Charset) {
            return (Charset)term;
        }
        return null;
    }

    private static boolean isSingleAscii(Charset c) {
        RangeSet rangeSet = c.getRangeSet();
        return rangeSet.isSingleton() && Codepoint.isAscii(rangeSet.iterator().next().getFirstCodepoint());
    }

    @Override
    public void visit(Nonterminal n) {
        this.sb.append(" ").append(n.getName());
    }

    @Override
    public void visit(Literal l) {
        throw new IllegalStateException();
    }

    public static void main(String[] args) throws IOException {
        String grammar;
        if (args.length != 1) {
            System.err.println("Usage: java " + ToREx.class.getName() + " <ixml-grammar>");
            System.exit(1);
        }
        String grammarString = (grammar = args[0]).startsWith("!") ? grammar.substring(1) : Blitz.urlContent(Blitz.url(grammar));
        System.out.println(ToREx.process(BNF.process(Ixml.parse(grammarString))));
    }
}

