/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.piped;

import java.util.ArrayList;
import net.sf.jsqlparser.statement.piped.PipeOperator;
import net.sf.jsqlparser.statement.piped.PipeOperatorVisitor;
import net.sf.jsqlparser.statement.select.SelectItem;

public class SelectPipeOperator
extends PipeOperator {
    private final String operatorName;
    private final String modifier;
    private final ArrayList<SelectItem<?>> selectItems = new ArrayList();

    public SelectPipeOperator(String operatorName, SelectItem<?> selectItem, String modifier) {
        this.operatorName = operatorName;
        this.modifier = modifier;
        this.selectItems.add(selectItem);
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public String getModifier() {
        return this.modifier;
    }

    public ArrayList<SelectItem<?>> getSelectItems() {
        return this.selectItems;
    }

    public SelectPipeOperator add(SelectItem<?> selectItem) {
        this.selectItems.add(selectItem);
        return this;
    }

    public SelectPipeOperator with(SelectItem<?> selectItem) {
        return this.add(selectItem);
    }

    @Override
    public <T, S> T accept(PipeOperatorVisitor<T, S> visitor, S context) {
        return visitor.visit(this, context);
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("|> ").append(this.operatorName);
        if (this.modifier != null && !this.modifier.isEmpty()) {
            builder.append(" ").append(this.modifier);
        }
        int i = 0;
        for (SelectItem<?> selectItem : this.selectItems) {
            builder.append(i++ > 0 ? ", " : " ").append(selectItem);
        }
        builder.append("\n");
        return builder;
    }
}

