/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;

public class InternalCursor {
    private static final float[] CURSOR_POINTS = new float[]{0.0f, 0.0f, 0.0f, 17.0f, 4.0f, 13.0f, 7.0f, 19.0f, 9.0f, 18.0f, 7.0f, 13.0f, 7.0f, 12.0f, 12.0f, 12.0f, 0.0f, 0.0f};
    private static final Map<Integer, ImageData> CURSOR_AT_ZOOM = new HashMap<Integer, ImageData>();
    private static ImageDescriptor CURRENT_CURSOR_DESCRIPTOR = ImageDescriptor.createFromImageDataProvider(zoom -> CURSOR_AT_ZOOM.computeIfAbsent(zoom, InternalCursor::getCursorAtZoom));

    private static ImageData getCursorAtZoom(int zoom) {
        float maxWidth = 0.0f;
        float maxHeight = 0.0f;
        int i = 0;
        while (i < CURSOR_POINTS.length) {
            maxWidth = Math.max(maxWidth, CURSOR_POINTS[i]);
            maxHeight = Math.max(maxHeight, CURSOR_POINTS[i + 1]);
            i += 2;
        }
        float zoomFactor = (float)zoom / 100.0f;
        int width = 1 + (int)Math.ceil(zoomFactor * maxWidth);
        int height = 1 + (int)Math.ceil(zoomFactor * maxHeight);
        Display display = Display.getDefault();
        Path path = new Path((Device)display);
        int i2 = 0;
        while (i2 < CURSOR_POINTS.length) {
            float x = zoomFactor * CURSOR_POINTS[i2];
            float y = zoomFactor * CURSOR_POINTS[i2 + 1];
            if (i2 == 0) {
                path.moveTo(x, y);
            } else {
                path.lineTo(x, y);
            }
            i2 += 2;
        }
        ImageData imageData = new ImageData(width, height, 32, new PaletteData(0xFF0000, 65280, 255));
        imageData.alphaData = new byte[width * height];
        Image image = new Image((Device)display, imageData);
        GC gc = new GC((Drawable)image);
        gc.setAlpha(0);
        gc.fillRectangle(0, 0, width, height);
        gc.setAlpha(255);
        gc.setAntialias(1);
        gc.setLineWidth(1);
        gc.setBackground(ColorConstants.white);
        gc.fillPath(path);
        gc.setBackground(ColorConstants.black);
        gc.drawPath(path);
        gc.dispose();
        path.dispose();
        imageData = image.getImageData(100);
        image.dispose();
        return imageData;
    }

    public static ImageDescriptor getCursorDescriptor() {
        return CURRENT_CURSOR_DESCRIPTOR;
    }

    public static void setCursorDescriptor(ImageDescriptor cursorDescriptor) {
        Objects.requireNonNull(cursorDescriptor, "The new cursor descriptor must not be null!");
        CURRENT_CURSOR_DESCRIPTOR = cursorDescriptor;
    }
}

