/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.Select;

public class ExplainStatement
implements Statement {
    private String keyword;
    private Select select;
    private LinkedHashMap<OptionType, Option> options;
    private Table table;

    public ExplainStatement(String keyword) {
        this.keyword = keyword;
    }

    public ExplainStatement() {
        this("EXPLAIN");
    }

    public ExplainStatement(String keyword, Table table) {
        this.keyword = keyword;
        this.table = table;
        this.select = null;
    }

    public ExplainStatement(String keyword, Select select, List<Option> optionList) {
        this.keyword = keyword;
        this.select = select;
        this.table = null;
        if (optionList != null && !optionList.isEmpty()) {
            this.options = new LinkedHashMap();
            for (Option o : optionList) {
                this.options.put(o.getType(), o);
            }
        }
    }

    public ExplainStatement(Select select) {
        this("EXPLAIN", select, null);
    }

    public Table getTable() {
        return this.table;
    }

    public ExplainStatement setTable(Table table) {
        this.table = table;
        return this;
    }

    public Select getStatement() {
        return this.select;
    }

    public void setStatement(Select select) {
        this.select = select;
    }

    public LinkedHashMap<OptionType, Option> getOptions() {
        return this.options == null ? null : new LinkedHashMap<OptionType, Option>(this.options);
    }

    public void addOption(Option option) {
        if (this.options == null) {
            this.options = new LinkedHashMap();
        }
        this.options.put(option.getType(), option);
    }

    public Option getOption(OptionType optionType) {
        if (this.options == null) {
            return null;
        }
        return this.options.get((Object)optionType);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public ExplainStatement setKeyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.keyword);
        if (this.table != null) {
            builder.append(" ").append(this.table);
        } else {
            if (this.options != null) {
                builder.append(" ");
                builder.append(this.options.values().stream().map(Option::formatOption).collect(Collectors.joining(" ")));
            }
            builder.append(" ");
            if (this.select != null) {
                this.select.appendTo(builder);
            }
        }
        return builder.toString();
    }

    @Override
    public <T, S> T accept(StatementVisitor<T> statementVisitor, S context) {
        return statementVisitor.visit(this, context);
    }

    public static class Option
    implements Serializable {
        private final OptionType type;
        private String value;

        public Option(OptionType type) {
            this.type = type;
        }

        public OptionType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String formatOption() {
            return this.type.name().replace("_", " ") + (String)(this.value != null ? " " + this.value : "");
        }

        public Option withValue(String value) {
            this.setValue(value);
            return this;
        }
    }

    public static enum OptionType {
        ANALYZE,
        VERBOSE,
        COSTS,
        BUFFERS,
        FORMAT,
        PLAN,
        PLAN_FOR;


        public static OptionType from(String type) {
            return Enum.valueOf(OptionType.class, type.toUpperCase());
        }
    }
}

