/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.geom.prep.PreparedPolygonPredicate;
import org.locationtech.jts.noding.SegmentIntersectionDetector;
import org.locationtech.jts.noding.SegmentStringUtil;

abstract class AbstractPreparedPolygonContains
extends PreparedPolygonPredicate {
    protected boolean requireSomePointInInterior = true;
    private boolean hasSegmentIntersection = false;
    private boolean hasProperIntersection = false;
    private boolean hasNonProperIntersection = false;

    public AbstractPreparedPolygonContains(PreparedPolygon prepPoly) {
        super(prepPoly);
    }

    protected boolean eval(Geometry geom) {
        boolean isTargetInTestArea;
        if (geom.getDimension() == 0) {
            return this.evalPoints(geom);
        }
        boolean isAllInTargetArea = this.isAllTestComponentsInTarget(geom);
        if (!isAllInTargetArea) {
            return false;
        }
        boolean properIntersectionImpliesNotContained = this.isProperIntersectionImpliesNotContainedSituation(geom);
        this.findAndClassifyIntersections(geom);
        if (properIntersectionImpliesNotContained && this.hasProperIntersection) {
            return false;
        }
        if (this.hasSegmentIntersection && !this.hasNonProperIntersection) {
            return false;
        }
        if (this.hasSegmentIntersection) {
            return this.fullTopologicalPredicate(geom);
        }
        return !(geom instanceof Polygonal) || !(isTargetInTestArea = this.isAnyTargetComponentInAreaTest(geom, this.prepPoly.getRepresentativePoints()));
    }

    private boolean evalPoints(Geometry geom) {
        boolean isAllInTargetArea = this.isAllTestPointsInTarget(geom);
        if (!isAllInTargetArea) {
            return false;
        }
        if (this.requireSomePointInInterior) {
            boolean isAnyInTargetInterior = this.isAnyTestPointInTargetInterior(geom);
            return isAnyInTargetInterior;
        }
        return true;
    }

    private boolean isProperIntersectionImpliesNotContainedSituation(Geometry testGeom) {
        if (testGeom instanceof Polygonal) {
            return true;
        }
        return this.isSingleShell(this.prepPoly.getGeometry());
    }

    private boolean isSingleShell(Geometry geom) {
        if (geom.getNumGeometries() != 1) {
            return false;
        }
        Polygon poly = (Polygon)geom.getGeometryN(0);
        int numHoles = poly.getNumInteriorRing();
        return numHoles == 0;
    }

    private void findAndClassifyIntersections(Geometry geom) {
        List lineSegStr = SegmentStringUtil.extractSegmentStrings(geom);
        SegmentIntersectionDetector intDetector = new SegmentIntersectionDetector();
        intDetector.setFindAllIntersectionTypes(true);
        this.prepPoly.getIntersectionFinder().intersects(lineSegStr, intDetector);
        this.hasSegmentIntersection = intDetector.hasIntersection();
        this.hasProperIntersection = intDetector.hasProperIntersection();
        this.hasNonProperIntersection = intDetector.hasNonProperIntersection();
    }

    protected abstract boolean fullTopologicalPredicate(Geometry var1);
}

