/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.dialogs.about;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.e4.ui.internal.dialogs.about.BrandingProperties;
import org.eclipse.e4.ui.internal.dialogs.about.IProductConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ProductProperties
extends BrandingProperties
implements IProductConstants {
    private final IProduct product;
    private String appName;
    private String aboutText;
    private Optional<ImageDescriptor> aboutImageDescriptor;
    private List<ImageDescriptor> windowImageDescriptors;
    private Optional<URL> welcomePageUrl;
    private String productName;
    private String productId;
    private static final String ABOUT_MAPPINGS = "$nl$/about.mappings";
    private static Map<Bundle, String[]> mappingsMap = new HashMap<Bundle, String[]>(4);

    private static String[] loadMappings(Bundle definingBundle) {
        URL location = FileLocator.find((Bundle)definingBundle, (IPath)IPath.fromOSString((String)ABOUT_MAPPINGS));
        PropertyResourceBundle bundle = null;
        if (location != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = location.openStream();){
                    bundle = new PropertyResourceBundle(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                bundle = null;
            }
        }
        ArrayList<String> mappingsList = new ArrayList<String>();
        if (bundle != null) {
            boolean found = true;
            int i = 0;
            while (found) {
                try {
                    mappingsList.add(bundle.getString(Integer.toString(i)));
                }
                catch (MissingResourceException e) {
                    found = false;
                }
                ++i;
            }
        }
        String[] mappings = mappingsList.toArray(new String[mappingsList.size()]);
        mappingsMap.put(definingBundle, mappings);
        return mappings;
    }

    private static String[] getMappings(Bundle definingBundle) {
        String[] mappings = mappingsMap.get(definingBundle);
        if (mappings == null) {
            mappings = ProductProperties.loadMappings(definingBundle);
        }
        if (mappings == null) {
            mappings = new String[]{};
        }
        return mappings;
    }

    public ProductProperties(IProduct product) {
        if (product == null) {
            throw new IllegalArgumentException();
        }
        this.product = product;
    }

    public String getAppName() {
        if (this.appName == null) {
            this.appName = ProductProperties.getAppName(this.product);
        }
        return this.appName;
    }

    public String getAboutText() {
        if (this.aboutText == null) {
            this.aboutText = ProductProperties.getAboutText(this.product);
        }
        return this.aboutText;
    }

    public ImageDescriptor getAboutImage() {
        if (this.aboutImageDescriptor == null) {
            this.aboutImageDescriptor = ProductProperties.aboutImage(Optional.ofNullable(this.product));
        }
        return this.aboutImageDescriptor.get();
    }

    public List<ImageDescriptor> getWindowImages() {
        if (this.windowImageDescriptors == null) {
            this.windowImageDescriptors = ProductProperties.getWindowImages(this.product);
        }
        return this.windowImageDescriptors;
    }

    public Optional<URL> welcomePageUrl() {
        if (this.welcomePageUrl == null) {
            this.welcomePageUrl = ProductProperties.getWelcomePageUrl(this.product);
        }
        return this.welcomePageUrl;
    }

    public String getProductName() {
        if (this.productName == null) {
            this.productName = ProductProperties.getProductName(this.product);
        }
        return this.productName;
    }

    public String getProductId() {
        if (this.productId == null) {
            this.productId = ProductProperties.getProductId(this.product);
        }
        return this.productId;
    }

    public static String getAppName(IProduct product) {
        String property = ProductProperties.getProperty(product, "appName");
        Object[] mappings = ProductProperties.getMappings(product.getDefiningBundle());
        return MessageFormat.format(property, mappings);
    }

    private static String getProperty(IProduct product, String prop) {
        return Optional.ofNullable(product.getProperty(prop)).orElse("");
    }

    public static String getAboutText(IProduct product) {
        String property = ProductProperties.getProperty(product, "aboutText");
        Object[] tempMappings = ProductProperties.getMappings(product.getDefiningBundle());
        int i = 0;
        while (i < tempMappings.length) {
            Object nextString = tempMappings[i];
            int length = ((String)nextString).length();
            if (length > 2 && ((String)nextString).charAt(0) == '$' && ((String)nextString).charAt(length - 1) == '$') {
                String systemPropertyKey = ((String)nextString).substring(1, length - 1);
                tempMappings[i] = System.getProperty(systemPropertyKey, "");
            }
            ++i;
        }
        return MessageFormat.format(property, tempMappings);
    }

    public static Optional<ImageDescriptor> aboutImage(Optional<IProduct> product) {
        if (product.isPresent()) {
            return ProductProperties.getImage(product.get().getProperty("aboutImage"), product.get().getDefiningBundle());
        }
        return Optional.empty();
    }

    public static List<ImageDescriptor> getWindowImages(IProduct product) {
        String property = product.getProperty("windowImages");
        return ProductProperties.getImages(property, product.getDefiningBundle());
    }

    public static Optional<URL> getWelcomePageUrl(IProduct product) {
        return ProductProperties.getUrl(product.getProperty("welcomePage"), product.getDefiningBundle());
    }

    public static String getProductName(IProduct product) {
        return product.getName();
    }

    public static String getProductId(IProduct product) {
        return product.getId();
    }
}

