/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

import java.util.Objects;
import java.util.logging.Level;
import org.eclipse.draw2d.internal.LoggerContext;

public abstract class Logger {
    private static LoggerContext CONTEXT = new LoggerContext.Stub();

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1, Throwable var2);

    public final void info(String message) {
        this.info(message, null);
    }

    public final void warn(String message) {
        this.warn(message, null);
    }

    public final void error(String message) {
        this.error(message, null);
    }

    public static void setContext(LoggerContext context) throws NullPointerException {
        Objects.requireNonNull(context);
        CONTEXT = context;
    }

    public static Logger getLogger(Class<?> clazz) {
        return CONTEXT.getLogger(clazz);
    }

    public static final class Stub
    extends Logger {
        private final java.util.logging.Logger logger;

        public Stub(Class<?> clazz) {
            this.logger = java.util.logging.Logger.getLogger(clazz.getName());
        }

        @Override
        public void info(String message, Throwable throwable) {
            this.logger.log(Level.INFO, message, throwable);
        }

        @Override
        public void warn(String message, Throwable throwable) {
            this.logger.log(Level.WARNING, message, throwable);
        }

        @Override
        public void error(String message, Throwable throwable) {
            this.logger.log(Level.SEVERE, message, throwable);
        }
    }
}

