/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.math.BigInteger;
import java.sql.ResultSet;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataFile;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTablespace;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.ByteNumberFormat;

public class AltibaseDataFile4Disk
extends AltibaseDataFile {
    private BigInteger currSize;
    private BigInteger nextSize;
    private BigInteger initSize;
    private BigInteger maxSize;
    private boolean isAutoExtend;
    private AltibaseTablespace.State state;

    protected AltibaseDataFile4Disk(AltibaseTablespace tablespace, ResultSet dbResult) {
        super(tablespace, dbResult);
        this.currSize = new BigInteger(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CURRSIZE"));
        this.nextSize = new BigInteger(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NEXTSIZE"));
        this.initSize = new BigInteger(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INITSIZE"));
        this.maxSize = new BigInteger(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MAXSIZE"));
        this.isAutoExtend = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"AUTOEXTEND") == 1;
        this.state = AltibaseTablespace.State.getStateByIdx(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"STATE"));
    }

    @Property(viewable=true, order=4, formatter=ByteNumberFormat.class)
    public BigInteger getCurrSize() {
        return this.currSize.multiply(new BigInteger(((AltibaseTablespace)this.getParentObject()).getPageSizeInBytesStr()));
    }

    @Property(viewable=true, order=5, formatter=ByteNumberFormat.class)
    public BigInteger getNextSize() {
        return this.nextSize.multiply(new BigInteger(((AltibaseTablespace)this.getParentObject()).getPageSizeInBytesStr()));
    }

    @Property(viewable=true, order=6, formatter=ByteNumberFormat.class)
    public BigInteger getInitSize() {
        return this.initSize.multiply(new BigInteger(((AltibaseTablespace)this.getParentObject()).getPageSizeInBytesStr()));
    }

    @Property(viewable=true, order=7, formatter=ByteNumberFormat.class)
    public BigInteger getMaxSize() {
        return this.maxSize.multiply(new BigInteger(((AltibaseTablespace)this.getParentObject()).getPageSizeInBytesStr()));
    }

    @Property(viewable=true, order=8)
    public boolean getAutoExtend() {
        return this.isAutoExtend;
    }

    @Property(viewable=true, order=10)
    public String getState() {
        return this.state.name();
    }
}

