/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStringValueHandler;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCColumnMetaData;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.BeanUtils;

public class PostgreIntervalValueHandler
extends JDBCStringValueHandler {
    private static final Log log = Log.getLog(PostgreIntervalValueHandler.class);
    public static final PostgreIntervalValueHandler INSTANCE = new PostgreIntervalValueHandler();
    private static final DecimalFormat SECONDS_FORMAT;
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    private static final long MILLISECONDS_IN_MINUTE = 60000L;
    private static final long MILLISECONDS_IN_HOUR = 3600000L;
    private static final long MILLISECONDS_IN_DAY = 86400000L;
    private static final long MILLISECONDS_IN_MONTH = 2592000000L;
    private static final long MILLISECONDS_IN_YEAR = 31536000000L;
    private static final String intervalRegex = "(?i)(?<sign>-)?\\s*(?:(?<years>\\d+)\\s+years?)?\\s*(?:(?<months>\\d+)\\s+mon(?:s|ths)?)?\\s*(?:(?<days>\\d+)\\s+days?)?\\s*(?:(?<time>\\d{2}:\\d{2}:\\d{2}(?:\\.\\d+)?))?\\b";
    private static final Pattern pattern;

    static {
        pattern = Pattern.compile(intervalRegex);
        SECONDS_FORMAT = new DecimalFormat("0.00####");
        DecimalFormatSymbols dfs = SECONDS_FORMAT.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        SECONDS_FORMAT.setDecimalFormatSymbols(dfs);
    }

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws SQLException {
        return resultSet.getString(index);
    }

    public void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws SQLException {
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else {
            statement.setObject(paramIndex, (Object)value.toString(), 1111);
        }
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        DBSDataContainer dataContainer;
        JDBCColumnMetaData columnMetaData;
        DBCExecutionSource source;
        boolean isPgObject = false;
        if (column instanceof JDBCColumnMetaData && (source = (columnMetaData = (JDBCColumnMetaData)column).getSource()) != null && (dataContainer = source.getDataContainer()) != null) {
            isPgObject = PostgreUtils.isPgObject(dataContainer.getDataSource(), value);
        }
        if (value != null && isPgObject) {
            try {
                Number years = (Number)BeanUtils.readObjectProperty((Object)value, (String)"years");
                Number months = (Number)BeanUtils.readObjectProperty((Object)value, (String)"months");
                Number days = (Number)BeanUtils.readObjectProperty((Object)value, (String)"days");
                Number hours = (Number)BeanUtils.readObjectProperty((Object)value, (String)"hours");
                Number minutes = (Number)BeanUtils.readObjectProperty((Object)value, (String)"minutes");
                Number seconds = (Number)BeanUtils.readObjectProperty((Object)value, (String)"seconds");
                StringBuilder str = new StringBuilder();
                if (years != null && years.intValue() > 0) {
                    str.append(years).append(" year").append(years.intValue() > 1 ? "s" : "").append(" ");
                }
                if (months != null && months.intValue() > 0) {
                    str.append(months).append(" month").append(months.intValue() > 1 ? "s" : "").append(" ");
                }
                if (days != null && days.intValue() > 0) {
                    str.append(days).append(" day").append(days.intValue() > 1 ? "s" : "").append(" ");
                }
                str.append(hours).append(":").append(minutes).append(":").append(seconds).append(SECONDS_FORMAT.format(seconds));
                return str.toString();
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return super.getValueDisplayString(column, value, format);
    }

    public Comparator<Object> getComparator() {
        return (o1, o2) -> {
            long leftInterval = this.getSecondsFromInterval((String)o1);
            long rightInterval = this.getSecondsFromInterval((String)o2);
            return Long.compare(leftInterval, rightInterval);
        };
    }

    private long getSecondsFromInterval(String interval) {
        Matcher matcher = pattern.matcher(interval);
        long totalSeconds = 0L;
        if (matcher.find()) {
            String sign = matcher.group("sign") != null ? "-" : "";
            String years = matcher.group("years");
            String months = matcher.group("months");
            String days = matcher.group("days");
            String time = matcher.group("time");
            if (years != null) {
                totalSeconds += Long.parseLong(years) * 31536000000L;
            }
            if (months != null) {
                totalSeconds += Long.parseLong(months) * 2592000000L;
            }
            if (days != null) {
                totalSeconds += Long.parseLong(days) * 86400000L;
            }
            if (time != null) {
                String[] timeParts = time.split(":");
                totalSeconds += (long)Integer.parseInt(timeParts[0]) * 3600000L;
                totalSeconds += (long)Integer.parseInt(timeParts[1]) * 60000L;
                long intValue = (long)Double.parseDouble(timeParts[2]);
                totalSeconds += intValue * 1000L;
                totalSeconds += (long)(Double.parseDouble(timeParts[2]) - (double)intValue);
            }
            if ("-".equals(sign)) {
                totalSeconds = -totalSeconds;
            }
        }
        return totalSeconds;
    }
}

