/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.security;

import java.sql.ResultSet;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthBase;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthHeldType;
import org.jkiss.dbeaver.ext.db2.model.security.DB2Grantee;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DB2AuthColumn
extends DB2AuthBase {
    private static final String UPDATE_PRIVILEGE = "U";
    private DB2AuthHeldType reference = DB2AuthHeldType.N;
    private DB2AuthHeldType update = DB2AuthHeldType.N;

    public DB2AuthColumn(DBRProgressMonitor monitor, DB2Grantee db2Grantee, DB2TableColumn db2TableColumn, ResultSet resultSet) throws DBException {
        super(monitor, db2Grantee, (DBSObject)db2TableColumn, resultSet);
        String privType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ALTERINAUTH");
        String grantable = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CREATEINAUTH");
        if (privType.equals(UPDATE_PRIVILEGE)) {
            this.update = grantable.equals(DB2AuthHeldType.N.name()) ? DB2AuthHeldType.Y : DB2AuthHeldType.G;
        } else {
            this.reference = grantable.equals(DB2AuthHeldType.N.getName()) ? DB2AuthHeldType.Y : DB2AuthHeldType.G;
        }
    }

    @Override
    @Property(viewable=true, order=2)
    public DBSObject getObject() {
        return super.getObject();
    }

    @Override
    @Property(viewable=true, order=1)
    public DB2Schema getObjectSchema() {
        return super.getObjectSchema();
    }

    @Property(viewable=true, order=20, category="Authorities")
    public DB2AuthHeldType getReference() {
        return this.reference;
    }

    @Property(viewable=true, order=21, category="Authorities")
    public DB2AuthHeldType getUpdate() {
        return this.update;
    }
}

