/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class CaseExpression
extends ASTNodeAccessImpl
implements Expression {
    private boolean usingBrackets = false;
    private Expression switchExpression;
    private List<WhenClause> whenClauses;
    private Expression elseExpression;

    public CaseExpression() {
    }

    public CaseExpression(WhenClause ... whenClauses) {
        this.whenClauses = Arrays.asList(whenClauses);
    }

    public CaseExpression(Expression elseExpression, WhenClause ... whenClauses) {
        this.elseExpression = elseExpression;
        this.whenClauses = Arrays.asList(whenClauses);
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    public Expression getSwitchExpression() {
        return this.switchExpression;
    }

    public void setSwitchExpression(Expression switchExpression) {
        this.switchExpression = switchExpression;
    }

    public Expression getElseExpression() {
        return this.elseExpression;
    }

    public void setElseExpression(Expression elseExpression) {
        this.elseExpression = elseExpression;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public void setWhenClauses(List<WhenClause> whenClauses) {
        this.whenClauses = whenClauses;
    }

    @Override
    public String toString() {
        return (this.usingBrackets ? "(" : "") + "CASE " + (String)(this.switchExpression != null ? this.switchExpression + " " : "") + PlainSelect.getStringList(this.whenClauses, false, false) + " " + (String)(this.elseExpression != null ? "ELSE " + this.elseExpression + " " : "") + "END" + (this.usingBrackets ? ")" : "");
    }

    public CaseExpression withSwitchExpression(Expression switchExpression) {
        this.setSwitchExpression(switchExpression);
        return this;
    }

    public CaseExpression withWhenClauses(WhenClause ... whenClauses) {
        return this.withWhenClauses(Arrays.asList(whenClauses));
    }

    public CaseExpression withWhenClauses(List<WhenClause> whenClauses) {
        this.setWhenClauses(whenClauses);
        return this;
    }

    public CaseExpression withElseExpression(Expression elseExpression) {
        this.setElseExpression(elseExpression);
        return this;
    }

    public CaseExpression addWhenClauses(WhenClause ... whenClauses) {
        List collection = Optional.ofNullable(this.getWhenClauses()).orElseGet(ArrayList::new);
        Collections.addAll(collection, whenClauses);
        return this.withWhenClauses(collection);
    }

    public CaseExpression addWhenClauses(Collection<? extends WhenClause> whenClauses) {
        List collection = Optional.ofNullable(this.getWhenClauses()).orElseGet(ArrayList::new);
        collection.addAll(whenClauses);
        return this.withWhenClauses(collection);
    }

    public <E extends Expression> E getSwitchExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getSwitchExpression()));
    }

    public <E extends Expression> E getElseExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getElseExpression()));
    }

    public boolean isUsingBrackets() {
        return this.usingBrackets;
    }

    public void setUsingBrackets(boolean usingBrackets) {
        this.usingBrackets = usingBrackets;
    }

    public CaseExpression withUsingBrackets(boolean usingBrackets) {
        this.usingBrackets = usingBrackets;
        return this;
    }
}

