/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation.grids;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.cts.cs.GeographicExtent;
import org.cts.op.transformation.grids.GeographicGrid;

public class IGNVerticalGrid
extends GeographicGrid {
    int orderType;
    boolean isCoordinate;
    boolean isPrecision;
    double[] globalTranslation;

    public IGNVerticalGrid(InputStream is) throws Exception {
        this(is, true);
    }

    public IGNVerticalGrid(InputStream is, boolean zip) throws Exception {
        boolean lonlat;
        String ignFile;
        boolean firstRecord = true;
        if (zip) {
            int nb;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
            ZipEntry ze = zis.getNextEntry();
            byte[] bytes = new byte[32768];
            StringBuilder sb = new StringBuilder();
            while ((nb = zis.read(bytes)) != -1) {
                sb.append(new String(bytes, 0, nb));
            }
            ignFile = sb.toString();
        } else {
            byte[] bb = new byte[is.available()];
            is.read(bb);
            ignFile = new String(bb);
        }
        StringTokenizer st = new StringTokenizer(ignFile, "\r\n");
        String gr = st.nextToken();
        StringTokenizer stt = new StringTokenizer(gr, " \t");
        if (!stt.hasMoreTokens()) {
            throw new Exception("Missing min longitude in line : " + gr);
        }
        String token = stt.nextToken();
        this.x0 = Double.parseDouble(token);
        if (!stt.hasMoreTokens()) {
            throw new Exception("Missing maximum longitude in line : " + gr);
        }
        token = stt.nextToken();
        this.xL = Double.parseDouble(token);
        if (!stt.hasMoreTokens()) {
            throw new Exception("Missing minimum latitude in line : " + gr);
        }
        token = stt.nextToken();
        this.y0 = Double.parseDouble(token);
        if (!stt.hasMoreTokens()) {
            throw new Exception("Missing maximum latitude in line : " + gr);
        }
        token = stt.nextToken();
        this.yL = Double.parseDouble(token);
        if (!stt.hasMoreTokens()) {
            throw new Exception("Missing cell size in line : " + gr);
        }
        token = stt.nextToken();
        this.dx = Double.parseDouble(token);
        double gridWidth = Math.rint((this.xL - this.x0) * 1.0E12) / 1.0E12;
        this.colNumber = (int)Math.rint(gridWidth / this.dx) + 1;
        if (!stt.hasMoreTokens()) {
            throw new Exception("Missing cell size in line : " + gr);
        }
        token = stt.nextToken();
        this.dy = Double.parseDouble(token);
        double gridHeight = Math.rint((this.yL - this.y0) * 1.0E12) / 1.0E12;
        this.rowNumber = (int)Math.rint(gridHeight / this.dy) + 1;
        if (!stt.hasMoreTokens()) {
            throw new Exception("Missing information in line : " + gr);
        }
        token = stt.nextToken();
        this.orderType = Integer.parseInt(token);
        if (!stt.hasMoreTokens()) {
            throw new Exception("Missing information mode : " + gr);
        }
        token = stt.nextToken();
        this.isCoordinate = token.equals("1");
        if (!stt.hasMoreTokens()) {
            throw new Exception("Missing information in line : " + gr);
        }
        token = stt.nextToken();
        this.dim = Integer.parseInt(token);
        if (!stt.hasMoreTokens()) {
            throw new Exception("Missing information in line : " + gr);
        }
        token = stt.nextToken();
        this.isPrecision = token.equals("1");
        this.globalTranslation = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            if (!stt.hasMoreTokens()) {
                throw new Exception("Missing precision unit in line : " + gr);
            }
            token = stt.nextToken();
            this.globalTranslation[i] = Double.parseDouble(token);
        }
        this.values = new double[this.rowNumber][this.colNumber][this.dim];
        int nbdec = 0;
        int i = this.orderType == 2 || this.orderType == 3 ? this.rowNumber - 1 : 0;
        int j = 0;
        int[] incr = new int[2];
        double[] t = new double[this.dim];
        boolean bl = lonlat = this.orderType == 1 || this.orderType == 3;
        while (st.hasMoreTokens()) {
            int index = 0;
            String[] gg = st.nextToken().trim().split("[ \t]+");
            int max = gg.length;
            while (index != max) {
                try {
                    if (this.isCoordinate) {
                        double lat;
                        double lon;
                        if (firstRecord) {
                            boolean bl2 = lonlat = Double.parseDouble(gg[index]) == this.x0;
                        }
                        if (lonlat) {
                            lon = Double.parseDouble(gg[index]);
                            lat = Double.parseDouble(gg[++index]);
                            ++index;
                        } else {
                            lat = Double.parseDouble(gg[index]);
                            lon = Double.parseDouble(gg[++index]);
                            ++index;
                        }
                        i = (int)Math.rint((lat - this.y0) / this.dy);
                        j = (int)Math.rint((lon - this.x0) / this.dx);
                    } else {
                        incr = this.increment(i, j);
                    }
                    String[] dec = gg[index].split("\\.");
                    if (dec.length > 1) {
                        nbdec = Math.max(nbdec, dec[1].length());
                    }
                    for (int k = 0; k < this.dim; ++k) {
                        t[k] = Double.parseDouble(gg[index]);
                        ++index;
                    }
                    if (this.isPrecision) {
                        String prec = gg[index];
                        ++index;
                    }
                    System.arraycopy(t, 0, this.values[i][j], 0, this.dim);
                    if (!this.isCoordinate) {
                        i = incr[0];
                        j = incr[1];
                    }
                    firstRecord = false;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        this.scale = (int)Math.rint(Math.pow(10.0, nbdec));
        this.extent = new GeographicExtent("GG", this.y0, this.yL, this.x0, this.xL, this.modulo);
    }

    private int[] increment(int i, int j) {
        int[] incr = new int[2];
        switch (this.orderType) {
            case 1: {
                if (i == this.rowNumber - 1) {
                    i = 0;
                }
                incr[0] = ++i;
                incr[1] = ++j;
                break;
            }
            case 2: {
                if (j == this.colNumber - 1) {
                    j = 0;
                }
                incr[0] = --i;
                incr[1] = ++j;
                break;
            }
            case 3: {
                if (i == 0) {
                    i = this.rowNumber - 1;
                }
                incr[0] = --i;
                incr[1] = ++j;
                break;
            }
            case 4: {
                if (j == this.colNumber - 1) {
                    j = 0;
                }
                incr[0] = ++i;
                incr[1] = ++j;
            }
        }
        return incr;
    }
}

