/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorDefinitionOverridable;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.themes.ICategorizedThemeElementDefinition;
import org.eclipse.ui.internal.themes.IEditable;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.ThemeElementDefinition;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.ColorUtil;

public class ColorDefinition
extends ThemeElementDefinition
implements IPluginContribution,
IHierarchalThemeElementDefinition,
ICategorizedThemeElementDefinition,
IEditable,
IColorDefinitionOverridable {
    private static final RGB DEFAULT_COLOR_VALUE = new RGB(0, 0, 0);
    private String defaultsTo;
    private final String pluginId;
    private String rawValue;
    boolean isEditable;
    private RGB parsedValue;

    public ColorDefinition(String label, String id, String defaultsTo, String value, String categoryId, boolean isEditable, String description, String pluginId) {
        super(id, label, description, categoryId);
        this.defaultsTo = defaultsTo;
        this.rawValue = value;
        this.isEditable = isEditable;
        this.pluginId = pluginId;
    }

    public ColorDefinition(ColorDefinition original, RGB value) {
        super(original.getId(), original.getName(), original.getDescription(), original.getCategoryId());
        this.isEditable = original.isEditable();
        this.pluginId = original.getPluginId();
        this.parsedValue = value;
    }

    @Override
    public String getDefaultsTo() {
        return this.defaultsTo;
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    public RGB getValue() {
        if (this.parsedValue == null) {
            try {
                this.parsedValue = ColorUtil.getColorValue(this.rawValue);
            }
            catch (DataFormatException e) {
                this.parsedValue = DEFAULT_COLOR_VALUE;
                IStatus status = StatusUtil.newStatus(2, "Could not parse value for theme color " + this.getId(), (Throwable)e);
                StatusManager.getManager().handle(status, 1);
            }
        }
        return this.parsedValue;
    }

    @Override
    public void resetToDefaultValue() {
        this.parsedValue = null;
        super.resetToDefaultValue();
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColorDefinition) {
            return this.getId().equals(((ColorDefinition)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public void setValue(RGB data) {
        if (data != null) {
            this.parsedValue = data;
            this.appendState(1);
        }
    }

    public void setEditable(Boolean editable) {
        this.isEditable = editable;
    }
}

