/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.text.CompositeBox;
import org.eclipse.draw2d.text.FlowBox;

public abstract class LineBox
extends CompositeBox {
    int contentAscent;
    int contentDescent;
    List<FlowBox> fragments = new ArrayList<FlowBox>();

    @Override
    public void add(FlowBox child) {
        this.fragments.add(child);
        this.width += child.getWidth();
        this.contentAscent = Math.max(this.contentAscent, child.getOuterAscent());
        this.contentDescent = Math.max(this.contentDescent, child.getOuterDescent());
    }

    @Override
    public int getAscent() {
        int ascent = 0;
        for (FlowBox fragment : this.fragments) {
            ascent = Math.max(ascent, fragment.getAscent());
        }
        return ascent;
    }

    int getAvailableWidth() {
        if (this.recommendedWidth < 0) {
            return Integer.MAX_VALUE;
        }
        return this.recommendedWidth - this.getWidth();
    }

    @Override
    int getBottomMargin() {
        return 0;
    }

    @Override
    public int getDescent() {
        int descent = 0;
        for (FlowBox fragment : this.fragments) {
            descent = Math.max(descent, fragment.getDescent());
        }
        return descent;
    }

    List<FlowBox> getFragments() {
        return this.fragments;
    }

    @Override
    int getTopMargin() {
        return 0;
    }

    public boolean isOccupied() {
        return !this.fragments.isEmpty();
    }

    @Override
    public boolean requiresBidi() {
        return this.getFragments().stream().anyMatch(FlowBox::requiresBidi);
    }
}

