/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.AEADSecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;

public class BcAEADSecretKeyEncryptorBuilder
implements AEADSecretKeyEncryptorBuilder {
    private int aeadAlgorithm;
    private int symmetricAlgorithm;
    private S2K.Argon2Params argon2Params;
    private SecureRandom random = new SecureRandom();

    public BcAEADSecretKeyEncryptorBuilder(int n, int n2, S2K.Argon2Params argon2Params) {
        this.aeadAlgorithm = n;
        this.symmetricAlgorithm = n2;
        this.argon2Params = argon2Params;
    }

    public BcAEADSecretKeyEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public PBESecretKeyEncryptor build(char[] cArray, final PublicKeyPacket publicKeyPacket) {
        return new PBESecretKeyEncryptor(this.symmetricAlgorithm, this.aeadAlgorithm, this.argon2Params, this.random, cArray){
            private byte[] iv;
            {
                super(n, n2, argon2Params, secureRandom, cArray);
                this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
                this.random.nextBytes(this.iv);
            }

            @Override
            public byte[] encryptKeyData(byte[] byArray, byte[] byArray2, int n, int n2) throws PGPException {
                try {
                    return BcAEADUtil.processAeadKeyData(true, this.encAlgorithm, this.aeadAlgorithm, this.getKey(), this.getCipherIV(), publicKeyPacket.getPacketTag() == 6 ? 5 : 7, publicKeyPacket.getVersion(), byArray2, n, n2, publicKeyPacket.getEncodedContents());
                }
                catch (IOException iOException) {
                    throw new PGPException("Exception AEAD protecting private key material", iOException);
                }
            }

            @Override
            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

