/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.copilot;

import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.BaseCompletionEngine;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotClient;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotModels;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotProperties;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatRequest;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatResponse;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotMessage;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotSessionToken;
import org.jkiss.dbeaver.model.ai.utils.DisposableLazyValue;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class CopilotCompletionEngine<P extends CopilotProperties>
extends BaseCompletionEngine<P> {
    protected final DisposableLazyValue<CopilotClient, DBException> client = new DisposableLazyValue<CopilotClient, DBException>(){

        @NotNull
        protected CopilotClient initialize() throws DBException {
            return CopilotCompletionEngine.this.createClient();
        }

        @Override
        protected void onDispose(@NotNull CopilotClient disposedValue) {
            disposedValue.close();
        }
    };
    private CopilotSessionToken sessionToken;

    public CopilotCompletionEngine(@NotNull P properties) {
        super(properties);
    }

    @Override
    @NotNull
    public List<AIModel> getModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((CopilotClient)this.client.getInstance()).loadModels(monitor, this.requestSessionToken(monitor).token()).stream().map(model -> CopilotModels.getModelByName(model.id()).orElse(new AIModel(model.id(), null, Set.of()))).toList();
    }

    @Override
    @NotNull
    public AIEngineResponse requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        CopilotChatRequest chatRequest = CopilotChatRequest.builder().withModel(this.getModelName()).withMessages(request.getMessages().stream().map(CopilotMessage::from).toList()).withTemperature(((CopilotProperties)this.properties).getTemperature()).withStream(false).withIntent(false).withTopP(1).withN(1).build();
        CopilotChatResponse chatResponse = ((CopilotClient)this.client.getInstance()).chat(monitor, this.requestSessionToken(monitor).token(), chatRequest);
        List<String> choices = chatResponse.choices().stream().map(it -> it.message().content()).toList();
        return new AIEngineResponse(AIMessageType.ASSISTANT, choices, null);
    }

    @Override
    public void requestCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request, @NotNull AIEngineResponseConsumer listener) throws DBException {
        CopilotChatRequest chatRequest = CopilotChatRequest.builder().withModel(this.getModelName()).withMessages(request.getMessages().stream().map(CopilotMessage::from).toList()).withTemperature(((CopilotProperties)this.properties).getTemperature()).withStream(true).withIntent(false).withTopP(1).withN(1).build();
        ((CopilotClient)this.client.getInstance()).createChatCompletionStream(monitor, this.requestSessionToken(monitor).token(), chatRequest, listener);
    }

    @Override
    public int getContextWindowSize(@NotNull DBRProgressMonitor monitor) throws DBException {
        Integer contextWindowSize = ((CopilotProperties)this.properties).getContextWindowSize();
        if (contextWindowSize != null) {
            return contextWindowSize;
        }
        throw new DBException("Context window size is not defined in Copilot properties. Please set it explicitly or use a known model with a predefined context window size.");
    }

    @Override
    public void close() throws DBException {
        this.client.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected CopilotSessionToken requestSessionToken(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.sessionToken != null) {
            return this.sessionToken;
        }
        CopilotCompletionEngine copilotCompletionEngine = this;
        synchronized (copilotCompletionEngine) {
            if (this.sessionToken == null) {
                this.sessionToken = ((CopilotClient)this.client.getInstance()).requestSessionToken(monitor, ((CopilotProperties)this.properties).getToken());
            }
        }
        return this.sessionToken;
    }

    public String getModelName() throws DBException {
        return CommonUtils.toString((Object)((CopilotProperties)this.properties).getModel(), (String)"gpt-4o");
    }

    protected CopilotClient createClient() throws DBException {
        String token = ((CopilotProperties)this.properties).getToken();
        if (token == null || token.isEmpty()) {
            throw new DBException("Copilot API token is not set");
        }
        return new CopilotClient();
    }
}

