/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public class ActiveWizardDialog
extends WizardDialog {
    private final Set<String> resizedShells = new HashSet<String>();
    private boolean adaptContainerSizeToPages = false;
    private String finishButtonLabel = IDialogConstants.FINISH_LABEL;
    private String cancelButtonLabel = IDialogConstants.CANCEL_LABEL;

    public ActiveWizardDialog(IWorkbenchWindow window, IWizard wizard) {
        this(window, wizard, null);
    }

    public ActiveWizardDialog(IWorkbenchWindow window, IWizard wizard, IStructuredSelection selection) {
        super(window.getShell(), wizard);
        if (wizard instanceof IWorkbenchWizard) {
            ISelectionService selectionService;
            if (selection == null && (selectionService = window.getSelectionService()) != null && selectionService.getSelection() instanceof IStructuredSelection) {
                selection = (IStructuredSelection)selectionService.getSelection();
            }
            ((IWorkbenchWizard)wizard).init(window.getWorkbench(), selection);
        }
        this.addPageChangingListener(event -> {
            if (event.getCurrentPage() instanceof ActiveWizardPage) {
                ((ActiveWizardPage)event.getCurrentPage()).deactivatePage();
            }
        });
    }

    public int getShellStyle() {
        if (this.isModalWizard() || UIUtils.isInDialog()) {
            return super.getShellStyle();
        }
        return 0xC70 | ActiveWizardDialog.getDefaultOrientation();
    }

    protected boolean isModalWizard() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings("DBeaver.ActiveWizardDialog." + this.getWizard().getClass().getSimpleName());
    }

    public void setAdaptContainerSizeToPages(boolean adaptContainerSizeToPages) {
        this.adaptContainerSizeToPages = adaptContainerSizeToPages;
    }

    public void showPage(IWizardPage page) {
        super.showPage(page);
        if (this.adaptContainerSizeToPages && !this.resizedShells.contains(page.getName())) {
            UIUtils.resizeShell(this.getWizard().getContainer().getShell());
            this.resizedShells.add(page.getName());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button cancelButton = this.getButton(1);
        cancelButton.setText(this.cancelButtonLabel);
        Button finishButton = this.getButton(16);
        finishButton.setText(this.finishButtonLabel);
    }

    public void setFinishButtonLabel(String finishButtonLabel) {
        this.finishButtonLabel = finishButtonLabel;
    }

    public void setCancelButtonLabel(String cancelButtonLabel) {
        this.cancelButtonLabel = cancelButtonLabel;
    }
}

