/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PrefPageProjectNetworkProfiles;

public final class PrefPageGlobalProjectNetworkProfiles
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.globalNetworkProfiles";
    private PrefPageProjectNetworkProfiles networkProfilesPage;
    private Composite networkProfilesPageHolder;
    private int lastProjectIndex = -1;

    public void init(@NotNull IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        List projects = workspace.getProjects();
        Combo projectCombo = UIUtils.createLabelCombo((Composite)composite, (String)UIConnectionMessages.pref_page_network_profiles_global_project_label, (int)12);
        projectCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        projectCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DBPProject project = (DBPProject)projects.get(projectCombo.getSelectionIndex());
            if (!this.refreshActiveProject(project)) {
                projectCombo.select(this.lastProjectIndex);
                return;
            }
            this.lastProjectIndex = projectCombo.getSelectionIndex();
        }));
        UIUtils.createInfoLink((Composite)composite, (String)UIConnectionMessages.pref_page_network_profiles_global_project_hint, () -> {
            DBPProject dBPProject = (DBPProject)projects.get(projectCombo.getSelectionIndex());
            if (dBPProject instanceof RCPProject) {
                RCPProject project = (RCPProject)dBPProject;
                PrefPageProjectNetworkProfiles.open(this.getShell(), project, null);
                this.refreshActiveProject((DBPProject)project);
            }
        });
        this.networkProfilesPageHolder = new Composite(composite, 0);
        this.networkProfilesPageHolder.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(3, 1).create());
        this.networkProfilesPageHolder.setLayout((Layout)new FillLayout());
        DBPProject activeProject = workspace.getActiveProject();
        for (DBPProject project : projects) {
            projectCombo.add(project.getDisplayName());
            if (project != activeProject) continue;
            projectCombo.select(projectCombo.getItemCount() - 1);
        }
        if (projectCombo.getSelectionIndex() < 0) {
            projectCombo.select(0);
        }
        projectCombo.notifyListeners(13, new Event());
        return composite;
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        if (this.networkProfilesPage != null) {
            this.networkProfilesPage.performOk();
        }
        return true;
    }

    public void dispose() {
        if (this.networkProfilesPage != null) {
            this.networkProfilesPage.dispose();
        }
    }

    private boolean refreshActiveProject(@NotNull DBPProject project) {
        if (project.getDataSourceRegistry().hasError()) {
            DBWorkbench.getPlatformUI().showError("Error opening project", NLS.bind((String)"Can''t show network profiles for project ''{0}'' because it can''t be loaded", (Object)project.getDisplayName()));
            return false;
        }
        if (this.networkProfilesPage != null) {
            this.networkProfilesPage.getControl().dispose();
            this.networkProfilesPage.dispose();
            this.networkProfilesPage = null;
        }
        this.networkProfilesPage = new PrefPageProjectNetworkProfiles();
        this.networkProfilesPage.setProjectMeta(project);
        this.networkProfilesPage.createControl(this.networkProfilesPageHolder);
        this.networkProfilesPage.loadSettings();
        return true;
    }
}

