/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.fs.DBFFileStoreProvider;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ProgramInfo;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.file.FileTypeHandlerDescriptor;
import org.jkiss.dbeaver.ui.editors.file.FileTypeHandlerRegistry;
import org.jkiss.dbeaver.ui.editors.file.IFileTypeHandler;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DefaultResourceHandlerImpl
extends AbstractResourceHandler {
    public static final DefaultResourceHandlerImpl INSTANCE = new DefaultResourceHandlerImpl();

    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        if (resource instanceof IFolder) {
            return 30;
        }
        return super.getFeatures(resource);
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        ProgramInfo program = ProgramInfo.getProgram((IResource)resource);
        if (program != null) {
            return program.getProgram().getName();
        }
        return "resource";
    }

    @Nullable
    public String getResourceDescription(@NotNull IResource resource) {
        return "";
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        block15: {
            FileTypeHandlerDescriptor fthd;
            String fileExtension;
            Path path;
            IPath location;
            IPath iPath = location = resource instanceof EFSNIOResource ? null : resource.getLocation();
            if (location != null && Files.exists(path = location.toPath(), new LinkOption[0]) && !CommonUtils.isEmpty((String)(fileExtension = IOUtils.getFileExtension((Path)path))) && (fthd = FileTypeHandlerRegistry.getInstance().findHandler(fileExtension)) != null) {
                try {
                    IFileTypeHandler handler = fthd.createHandler();
                    handler.openFiles(Collections.singletonList(path), Map.of(), null);
                    return;
                }
                catch (ReflectiveOperationException e) {
                    throw new DBException("Cannot create file handler", (Throwable)e);
                }
            }
            if (resource instanceof DBFFileStoreProvider) {
                IEditorDescriptor editorDesc;
                IFileStore fileStore = ((DBFFileStoreProvider)resource).getFileStore();
                long length = fileStore.fetchInfo().getLength();
                if (!UIUtils.confirmAction((String)resource.getFullPath().toString(), (String)("Open remote resource '" + String.valueOf(resource.getFullPath()) + "'?\nSize = " + ByteNumberFormat.getInstance().format(length) + " bytes"))) {
                    return;
                }
                try {
                    editorDesc = IDE.getEditorDescriptor((IFile)((IFile)resource), (boolean)true, (boolean)true);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
                try {
                    Path target = (Path)UIUtils.runWithMonitor(monitor -> {
                        try {
                            Path tempFile = Files.createTempFile(DBWorkbench.getPlatform().getTempFolder(monitor, "external-files"), null, fileStore.getName(), new FileAttribute[0]);
                            Throwable throwable = null;
                            Object var4_6 = null;
                            try (InputStream is = fileStore.openInputStream(0, null);){
                                Throwable throwable2 = null;
                                Object var7_11 = null;
                                try (OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
                                    IFileInfo info = fileStore.fetchInfo(0, null);
                                    ContentUtils.copyStreams((InputStream)is, (long)info.getLength(), (OutputStream)os, (DBRProgressMonitor)monitor);
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                            return tempFile;
                        }
                        catch (IOException | CoreException e) {
                            throw new DBException("Error copying file", e);
                        }
                    });
                    if ("org.eclipse.ui.systemExternalEditor".equals(editorDesc.getId())) {
                        Program.launch((String)target.toString());
                        break block15;
                    }
                    IDE.openEditor((IWorkbenchPage)UIUtils.getActiveWorkbenchWindow().getActivePage(), (URI)DBFUtils.getUriFromPath((Path)target), (String)editorDesc.getId(), (boolean)true);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Error opening resource", "Can't open resource using external editor", (Throwable)e);
                }
            } else if (resource instanceof IFile) {
                IDE.openEditor((IWorkbenchPage)UIUtils.getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)resource));
            } else if (resource instanceof IFolder && location != null) {
                DBWorkbench.getPlatformUI().executeShellProgram(location.toOSString());
            } else {
                DBWorkbench.getPlatformUI().showError("Error opening resource", "Do not know how to open resource '" + String.valueOf(resource) + "'");
            }
        }
    }
}

