/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.phoenix.model.data;

import java.sql.Array;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCArrayValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PhoenixArrayValueHandler
extends JDBCArrayValueHandler {
    public static final PhoenixArrayValueHandler INSTANCE = new PhoenixArrayValueHandler();
    public static final String PHOENIX_ARRAY_TYPE = "PhoenixArray";

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object != null && object.getClass().getSimpleName().contains(PHOENIX_ARRAY_TYPE)) {
            return JDBCCollection.makeCollectionFromArray((JDBCSession)((JDBCSession)session), (DBSTypedObject)type, (Array)((Array)object));
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, 2003);
        } else if (value instanceof DBDCollection) {
            DBDCollection collection = (DBDCollection)value;
            if (collection.isNull()) {
                statement.setNull(paramIndex, 2003);
            } else if (collection instanceof JDBCCollection) {
                statement.setArray(paramIndex, ((JDBCCollection)collection).getArrayValue());
            } else {
                statement.setArray(paramIndex, (Array)collection.getRawValue());
            }
        } else {
            throw new DBCException("Array parameter type '" + value.getClass().getName() + "' not supported");
        }
    }
}

