/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageShellCommands;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.dbeaver.ui.dialogs.connection.EditBootstrapQueriesDialog;
import org.jkiss.dbeaver.ui.preferences.PrefPageConnectionClient;
import org.jkiss.dbeaver.ui.preferences.WizardPrefPage;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

class ConnectionPageInitialization
extends ConnectionWizardPage
implements IDialogPageProvider,
IDataSourceConnectionTester {
    static final String PAGE_NAME = ConnectionPageInitialization.class.getSimpleName();
    private static final Log log = Log.getLog(ConnectionPageInitialization.class);
    private static final String PAGE_DOCS_LINK = "Configure-Connection-Initialization-Settings";
    private DataSourceDescriptor dataSourceDescriptor;
    private Combo autocommit;
    private Combo isolationLevel;
    private Combo defaultCatalog;
    private Combo defaultSchema;
    private Spinner keepAliveInterval;
    private Button closeIdleConnectionsCheck;
    private Spinner closeIdleConnectionsPeriod;
    private boolean activated = false;
    private final List<DBPTransactionIsolation> supportedLevels = new ArrayList<DBPTransactionIsolation>();
    private List<String> bootstrapQueries;
    private boolean ignoreBootstrapErrors;
    private boolean txnOptionsLoaded = false;
    private ConnectionPageShellCommands shellCommandPage;
    private WizardPrefPage clientAppPage;

    private ConnectionPageInitialization() {
        super(PAGE_NAME);
        this.setTitle(CoreMessages.dialog_connection_wizard_connection_init);
        this.setDescription(CoreMessages.dialog_connection_wizard_connection_init_description);
    }

    ConnectionPageInitialization(@NotNull DataSourceDescriptor dataSourceDescriptor) {
        this();
        this.dataSourceDescriptor = dataSourceDescriptor;
        this.bootstrapQueries = new ArrayList<String>(dataSourceDescriptor.getConnectionConfiguration().getBootstrap().getInitQueries());
        this.ignoreBootstrapErrors = dataSourceDescriptor.getConnectionConfiguration().getBootstrap().isIgnoreErrors();
        this.shellCommandPage = new ConnectionPageShellCommands(dataSourceDescriptor);
        if (!dataSourceDescriptor.getDriver().isEmbedded()) {
            PrefPageConnectionClient pageConnectionClient = new PrefPageConnectionClient();
            pageConnectionClient.setElement((IAdaptable)dataSourceDescriptor);
            this.clientAppPage = new WizardPrefPage((IPreferencePage)pageConnectionClient, CoreMessages.dialog_connection_edit_wizard_connections, CoreMessages.dialog_connection_edit_wizard_connections_description);
        }
    }

    public void dispose() {
        super.dispose();
    }

    private static int getAutocommitSelIndex(DBPConnectionConfiguration configuration) {
        Boolean defaultAutoCommit = configuration.getBootstrap().getDefaultAutoCommit();
        return defaultAutoCommit == null ? 0 : (defaultAutoCommit != false ? 1 : 2);
    }

    private static Boolean getAutocommitValueFromIndex(int index) {
        return switch (index) {
            case 1 -> true;
            case 2 -> false;
            default -> null;
        };
    }

    public void activatePage() {
        if (this.dataSourceDescriptor != null) {
            if (!this.activated) {
                DBPConnectionConfiguration conConfig = this.dataSourceDescriptor.getConnectionConfiguration();
                this.autocommit.select(ConnectionPageInitialization.getAutocommitSelIndex(this.dataSourceDescriptor.getConnectionConfiguration()));
                this.isolationLevel.add("");
                DataSourceDescriptor originalDataSource = ((ConnectionWizard)this.getWizard()).getOriginalDataSource();
                if (originalDataSource != null && originalDataSource.isConnected()) {
                    DBPDataSource dataSource = originalDataSource.getDataSource();
                    this.loadDatabaseSettings(dataSource);
                }
                this.defaultCatalog.setText(CommonUtils.notEmpty((String)conConfig.getBootstrap().getDefaultCatalogName()));
                this.defaultSchema.setText(CommonUtils.notEmpty((String)conConfig.getBootstrap().getDefaultSchemaName()));
                this.keepAliveInterval.setSelection(conConfig.getKeepAliveInterval());
                this.closeIdleConnectionsCheck.setSelection(conConfig.isCloseIdleConnection());
                this.closeIdleConnectionsPeriod.setSelection(conConfig.getCloseIdleInterval() > 0 ? conConfig.getCloseIdleInterval() : conConfig.getConnectionType().getCloseIdleConnectionPeriod());
                this.closeIdleConnectionsPeriod.setEnabled(this.closeIdleConnectionsCheck.getSelection());
                this.activated = true;
            }
        } else {
            this.isolationLevel.setEnabled(false);
            this.defaultCatalog.setText("");
            this.defaultSchema.setText("");
        }
    }

    @Nullable
    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        ArrayList<ConnectionPageShellCommands> pages = new ArrayList<ConnectionPageShellCommands>();
        pages.add(this.shellCommandPage);
        if (this.clientAppPage != null) {
            pages.add((ConnectionPageShellCommands)this.clientAppPage);
        }
        return pages.toArray(new IDialogPage[0]);
    }

    private void loadDatabaseSettings(DBPDataSource dataSource) {
        try {
            ((ConnectionWizard)this.getWizard()).getRunnableContext().run(true, true, monitor -> this.loadDatabaseSettings(monitor, dataSource));
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Database info reading", "Error reading information from database", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void loadDatabaseSettings(DBRProgressMonitor monitor, DBPDataSource dataSource) {
        DBCExecutionContext executionContext;
        DBPDataSourceContainer dataSourceContainer = dataSource.getContainer();
        Collection txnLevels = CommonUtils.safeCollection((Collection)dataSource.getInfo().getSupportedTransactionsIsolation());
        Integer levelCode = dataSourceContainer.getDefaultTransactionsIsolation();
        UIUtils.syncExec(() -> {
            this.autocommit.select(ConnectionPageInitialization.getAutocommitSelIndex(this.dataSourceDescriptor.getConnectionConfiguration()));
            this.supportedLevels.clear();
            DBPTransactionIsolation defaultLevel = null;
            if (levelCode != null && !CommonUtils.isEmpty((Collection)txnLevels)) {
                for (DBPTransactionIsolation level : txnLevels) {
                    if (level.getCode() != levelCode.intValue()) continue;
                    defaultLevel = level;
                    break;
                }
            }
            this.isolationLevel.removeAll();
            this.supportedLevels.clear();
            for (DBPTransactionIsolation level : txnLevels) {
                if (!level.isEnabled()) continue;
                this.isolationLevel.add(level.getTitle());
                this.supportedLevels.add(level);
                if (!level.equals(defaultLevel)) continue;
                this.isolationLevel.select(this.isolationLevel.getItemCount() - 1);
            }
        });
        if (dataSource instanceof DBSObjectContainer && (executionContext = DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)true)) != null) {
            DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
            DBSObjectContainer catalogContainer = DBUtils.getChangeableObjectContainer((DBCExecutionContextDefaults)contextDefaults, (DBSObjectContainer)((DBSObjectContainer)dataSource), DBSCatalog.class);
            if (catalogContainer != null) {
                this.loadSelectableObject(monitor, catalogContainer, this.defaultCatalog, contextDefaults, true);
            }
            DBSObjectContainer schemaContainer = DBUtils.getChangeableObjectContainer((DBCExecutionContextDefaults)contextDefaults, (DBSObjectContainer)((DBSObjectContainer)dataSource), DBSSchema.class);
            this.loadSelectableObject(monitor, schemaContainer, this.defaultSchema, contextDefaults, false);
        }
        this.txnOptionsLoaded = true;
    }

    private void loadSelectableObject(@NotNull DBRProgressMonitor monitor, @Nullable DBSObjectContainer objectContainer, @NotNull Combo objectCombo, @Nullable DBCExecutionContextDefaults<?, ?> contextDefaults, boolean isCatalogs) {
        if (objectContainer != null) {
            try {
                ArrayList<String> objectNames = new ArrayList<String>();
                Collection children = objectContainer.getChildren(monitor);
                if (children != null) {
                    for (DBSObject child : children) {
                        if (!(child instanceof DBSObjectContainer)) continue;
                        objectNames.add(child.getName());
                    }
                }
                if (!objectNames.isEmpty()) {
                    UIUtils.syncExec(() -> {
                        if (!objectCombo.isDisposed()) {
                            String oldText = objectCombo.getText();
                            objectCombo.removeAll();
                            for (String name : objectNames) {
                                objectCombo.add(name);
                            }
                            if (!CommonUtils.isEmpty((String)oldText)) {
                                objectCombo.setText(oldText);
                            }
                            if (contextDefaults != null) {
                                DBSCatalog defaultObject;
                                Object object = defaultObject = isCatalogs ? contextDefaults.getDefaultCatalog() : contextDefaults.getDefaultSchema();
                                if (defaultObject != null) {
                                    objectCombo.setText(defaultObject.getName());
                                }
                            }
                        }
                    });
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't read schema list", (Throwable)e);
            }
        }
    }

    public void createControl(Composite parent) {
        Composite group = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Composite txnGroup = UIUtils.createTitledComposite((Composite)group, (String)CoreMessages.dialog_connection_edit_wizard_transactions, (int)2, (int)32, (int)-1);
        this.autocommit = UIUtils.createLabelCombo((Composite)txnGroup, (String)CoreMessages.action_menu_transactionMonitor_autocommitMode, (String)"Sets auto-commit mode for this connection.\nIf set to default then connection type configuration will be used.", (int)12);
        this.autocommit.setLayoutData((Object)new GridData(32));
        this.autocommit.add("Default");
        this.autocommit.add("Auto commit");
        this.autocommit.add("Manual commit");
        this.isolationLevel = UIUtils.createLabelCombo((Composite)txnGroup, (String)CoreMessages.dialog_connection_wizard_final_label_isolation_level, (String)CoreMessages.dialog_connection_wizard_final_label_isolation_level_tooltip, (int)12);
        UIUtils.createPreferenceLink((Composite)group, (String)CoreMessages.action_menu_transaction_pref_page_link_extended, (String)"org.jkiss.dbeaver.preferences.connectionTypes", null, null);
        Composite conGroup = UIUtils.createTitledComposite((Composite)group, (String)CoreMessages.dialog_connection_wizard_final_label_connection, (int)2, (int)32, (int)-1);
        this.defaultCatalog = UIUtils.createLabelCombo((Composite)conGroup, (String)CoreMessages.dialog_connection_wizard_final_label_default_database, (String)CoreMessages.dialog_connection_wizard_final_label_default_database_tooltip, (int)4);
        ((GridData)this.defaultCatalog.getLayoutData()).widthHint = UIUtils.getFontHeight((Control)this.defaultCatalog) * 20;
        this.defaultSchema = UIUtils.createLabelCombo((Composite)conGroup, (String)CoreMessages.dialog_connection_wizard_final_label_default_schema, (String)CoreMessages.dialog_connection_wizard_final_label_default_schema_tooltip, (int)4);
        ((GridData)this.defaultSchema.getLayoutData()).widthHint = UIUtils.getFontHeight((Control)this.defaultSchema) * 20;
        this.keepAliveInterval = UIUtils.createLabelSpinner((Composite)conGroup, (String)CoreMessages.dialog_connection_wizard_final_label_keepalive, (String)CoreMessages.dialog_connection_wizard_final_label_keepalive_tooltip, (int)0, (int)0, (int)Short.MAX_VALUE);
        Composite idleConComp = UIUtils.createComposite((Composite)conGroup, (int)2);
        idleConComp.setLayoutData((Object)GridDataFactory.create((int)768).span(2, 1).create());
        this.closeIdleConnectionsCheck = UIUtils.createCheckbox((Composite)idleConComp, (String)CoreMessages.dialog_connection_wizard_final_label_close_idle_connections, (String)CoreMessages.dialog_connection_wizard_final_label_close_idle_connections_tooltip, (boolean)true, (int)1);
        this.closeIdleConnectionsCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> this.closeIdleConnectionsPeriod.setEnabled(this.closeIdleConnectionsCheck.getSelection())));
        this.closeIdleConnectionsPeriod = UIUtils.createSpinner((Composite)idleConComp, (String)CoreMessages.dialog_connection_wizard_final_label_close_idle_connections_tooltip, (int)0, (int)0, (int)Short.MAX_VALUE);
        String bootstrapTooltip = CoreMessages.dialog_connection_wizard_final_label_bootstrap_tooltip;
        UIUtils.createControlLabel((Composite)conGroup, (String)CoreMessages.dialog_connection_wizard_final_label_bootstrap_query).setToolTipText(bootstrapTooltip);
        Button queriesConfigButton = UIUtils.createPushButton((Composite)conGroup, (String)CoreMessages.dialog_connection_wizard_configure, (Image)DBeaverIcons.getImage((DBPImage)DBIcon.TREE_SCRIPT));
        queriesConfigButton.setToolTipText(bootstrapTooltip);
        if (this.dataSourceDescriptor != null && !CommonUtils.isEmpty((Collection)this.dataSourceDescriptor.getConnectionConfiguration().getBootstrap().getInitQueries())) {
            queriesConfigButton.setFont(BaseThemeSettings.instance.baseFontBold);
        }
        queriesConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditBootstrapQueriesDialog dialog = new EditBootstrapQueriesDialog(ConnectionPageInitialization.this.getShell(), ConnectionPageInitialization.this.dataSourceDescriptor, ConnectionPageInitialization.this.bootstrapQueries, ConnectionPageInitialization.this.ignoreBootstrapErrors);
                if (dialog.open() == 0) {
                    ConnectionPageInitialization.this.bootstrapQueries = dialog.getQueries();
                    ConnectionPageInitialization.this.ignoreBootstrapErrors = dialog.isIgnoreErrors();
                }
            }
        });
        Control infoLabel = UIUtils.createInfoLabel((Composite)group, (String)CoreMessages.dialog_connection_wizard_connection_init_hint);
        infoLabel.setToolTipText(CoreMessages.dialog_connection_wizard_connection_init_hint_tip);
        Link urlHelpLabel = UIUtils.createLink((Composite)group, (String)CoreMessages.dialog_connection_wizard_connection_init_docs_hint, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)ConnectionPageInitialization.PAGE_DOCS_LINK));
            }
        });
        urlHelpLabel.setLayoutData((Object)new GridData(4, 2, false, false, 2, 1));
        this.setControl((Control)group);
        UIUtils.setHelp((Control)group, (String)"con-wizard-final");
    }

    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        if (this.activated) {
            dataSource.getConnectionConfiguration().getBootstrap().setDefaultAutoCommit(ConnectionPageInitialization.getAutocommitValueFromIndex(this.autocommit.getSelectionIndex()));
            if (this.txnOptionsLoaded) {
                int levelIndex;
                DBPTransactionIsolation level = null;
                if (!CommonUtils.isEmpty((String)this.isolationLevel.getText()) && (levelIndex = this.isolationLevel.getSelectionIndex()) >= 0) {
                    level = this.supportedLevels.get(levelIndex);
                }
                dataSource.getConnectionConfiguration().getBootstrap().setDefaultTransactionIsolation(level == null ? null : Integer.valueOf(level.getCode()));
            }
            DBPConnectionConfiguration confConfig = dataSource.getConnectionConfiguration();
            DBPConnectionBootstrap bootstrap = confConfig.getBootstrap();
            bootstrap.setDefaultCatalogName(this.defaultCatalog.getText());
            bootstrap.setDefaultSchemaName(this.defaultSchema.getText());
            bootstrap.setIgnoreErrors(this.ignoreBootstrapErrors);
            bootstrap.setInitQueries(this.bootstrapQueries);
            confConfig.setKeepAliveInterval(this.keepAliveInterval.getSelection());
            confConfig.setCloseIdleConnection(this.closeIdleConnectionsCheck.getSelection());
            if (confConfig.isCloseIdleConnection() && this.closeIdleConnectionsPeriod.getSelection() != confConfig.getConnectionType().getCloseIdleConnectionPeriod()) {
                confConfig.setCloseIdleInterval(this.closeIdleConnectionsPeriod.getSelection());
            } else {
                confConfig.setCloseIdleInterval(0);
            }
        }
        this.shellCommandPage.saveSettings(dataSource);
        if (this.clientAppPage != null) {
            this.clientAppPage.performFinish();
        }
    }

    public void setWizard(IWizard newWizard) {
        ConnectionWizard connectionWizard;
        super.setWizard(newWizard);
        if (newWizard instanceof ConnectionWizard && !(connectionWizard = (ConnectionWizard)newWizard).isNew()) {
            connectionWizard.addPropertyChangeListener(event -> {
                if ("connection-type".equals(event.getProperty())) {
                    DBPConnectionType type = (DBPConnectionType)event.getNewValue();
                    if (this.closeIdleConnectionsCheck != null) {
                        this.closeIdleConnectionsCheck.setSelection(type.isAutoCloseConnections());
                    }
                    if (this.closeIdleConnectionsPeriod != null) {
                        this.closeIdleConnectionsPeriod.setSelection(type.getCloseIdleConnectionPeriod());
                    }
                }
            });
        }
    }

    public void testConnection(DBCSession session) {
        this.loadDatabaseSettings(session.getProgressMonitor(), session.getDataSource());
    }
}

