/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.gis.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cugos.wkg.CircularString;
import org.cugos.wkg.CompoundCurve;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.CurvePolygon;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Geometry;
import org.cugos.wkg.LineString;
import org.cugos.wkg.LinearRing;
import org.cugos.wkg.MultiCurve;
import org.cugos.wkg.MultiLineString;
import org.cugos.wkg.MultiPolygon;
import org.cugos.wkg.MultiSurface;
import org.cugos.wkg.Polygon;
import org.cugos.wkg.WKBReader;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.gis.CircularArc;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.utils.CommonUtils;
import org.locationtech.jts.io.WKTReader;

public class WKGUtils {
    @NotNull
    public static DBGeometry parseWKT(@NotNull String wkt) throws DBCException {
        DBGeometry geometry;
        int srid = 0;
        if (wkt.startsWith("SRID=") && wkt.indexOf(59) > 5) {
            int index = wkt.indexOf(59);
            srid = CommonUtils.toInt((Object)wkt.substring(5, index));
            wkt = wkt.substring(index + 1);
        }
        try {
            geometry = new DBGeometry(new WKTReader().read(wkt));
        }
        catch (Exception e) {
            throw new DBCException("Error parsing geometry value from string", (Throwable)e);
        }
        if (srid != 0) {
            geometry.setSRID(srid);
        }
        return geometry;
    }

    public static DBGeometry parseWKB(String hexString) throws DBCException {
        Geometry wkgGeometry = new WKBReader().read(hexString);
        if (wkgGeometry != null) {
            int srid = CommonUtils.toInt((Object)wkgGeometry.getSrid());
            wkgGeometry.setSrid(null);
            return new DBGeometry(wkgGeometry, srid);
        }
        throw new DBCException("Invalid geometry object");
    }

    public static boolean isCurve(@Nullable Object value) {
        return value instanceof CircularString || value instanceof CompoundCurve || value instanceof CurvePolygon || value instanceof MultiCurve || value instanceof MultiSurface;
    }

    @NotNull
    public static Object linearize(@NotNull Geometry value) {
        return WKGUtils.linearize(value, 0.001);
    }

    @NotNull
    public static Geometry linearize(@NotNull Geometry value, double tolerance) {
        if (value instanceof CircularString) {
            return WKGUtils.convertCircularString((CircularString)value, tolerance);
        }
        if (value instanceof CompoundCurve) {
            return WKGUtils.convertCompoundCurve((CompoundCurve)value, tolerance);
        }
        if (value instanceof CurvePolygon) {
            return WKGUtils.convertCurvePolygon((CurvePolygon)value, tolerance);
        }
        if (value instanceof MultiCurve) {
            return WKGUtils.convertMultiCurve((MultiCurve)value, tolerance);
        }
        if (value instanceof MultiSurface) {
            return WKGUtils.convertMultiSurface((MultiSurface)value, tolerance);
        }
        return value;
    }

    @NotNull
    private static LineString convertCircularString(@NotNull CircularString value, double tolerance) {
        List input = value.getCoordinates();
        ArrayList<Coordinate> output = new ArrayList<Coordinate>();
        int i = 2;
        while (i < input.size()) {
            CircularArc arc = new CircularArc((Coordinate)input.get(i - 2), (Coordinate)input.get(i - 1), (Coordinate)input.get(i));
            output.addAll(arc.linearize(tolerance));
            i += 2;
        }
        return new LineString(output, Dimension.Two, value.getSrid());
    }

    @NotNull
    private static LineString convertCompoundCurve(@NotNull CompoundCurve value, double tolerance) {
        List coordinates = value.getCurves().stream().map(x -> WKGUtils.linearize((Geometry)x, tolerance)).flatMap(x -> x.getCoordinates().stream()).collect(Collectors.toList());
        return new LineString(coordinates, Dimension.Two, value.getSrid());
    }

    @NotNull
    private static Polygon convertCurvePolygon(@NotNull CurvePolygon value, double tolerance) {
        LinearRing outerLinearRing = Stream.of(value.getOuterCurve()).map(x -> WKGUtils.linearize((Geometry)x, tolerance)).map(x -> new LinearRing(x.getCoordinates(), x.getDimension(), x.getSrid())).findAny().get();
        List innerLinearRings = value.getInnerCurves().stream().map(x -> WKGUtils.linearize((Geometry)x, tolerance)).map(x -> new LinearRing(x.getCoordinates(), x.getDimension(), x.getSrid())).collect(Collectors.toList());
        return new Polygon(outerLinearRing, innerLinearRings, Dimension.Two, value.getSrid());
    }

    @NotNull
    private static MultiLineString convertMultiCurve(@NotNull MultiCurve value, double tolerance) {
        List strings = value.getCurves().stream().map(x -> (LineString)WKGUtils.linearize((Geometry)x, tolerance)).collect(Collectors.toList());
        return new MultiLineString(strings, Dimension.Two, value.getSrid());
    }

    @NotNull
    private static MultiPolygon convertMultiSurface(@NotNull MultiSurface value, double tolerance) {
        List polygons = value.getSurfaces().stream().map(x -> (Polygon)WKGUtils.linearize((Geometry)x, tolerance)).collect(Collectors.toList());
        return new MultiPolygon(polygons, Dimension.Two, value.getSrid());
    }
}

