/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.duckdb.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDollarQuoteRule;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.utils.CommonUtils;

public final class DuckDBSQLDialect
extends GenericSQLDialect
implements TPRuleProvider {
    private static final List<String> DUCKDB_KEYWORDS = List.of("INSTALL", "LOAD");

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addSQLKeywords(DUCKDB_KEYWORDS);
    }

    @NotNull
    public TPRule[] extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.INITIAL || position == TPRuleProvider.RulePosition.PARTITION) {
            boolean ddPlain = false;
            boolean ddTag = false;
            if (dataSource != null) {
                ddPlain = CommonUtils.getBoolean((String)dataSource.getConnectionConfiguration().getProviderProperty("duckdb.dd.plain.string"), (boolean)false);
                ddTag = CommonUtils.getBoolean((String)dataSource.getConnectionConfiguration().getProviderProperty("duckdb.dd.tag.string"), (boolean)false);
            }
            return new TPRule[]{new SQLDollarQuoteRule(position == TPRuleProvider.RulePosition.PARTITION, true, ddTag, ddPlain)};
        }
        return new TPRule[0];
    }

    public boolean supportsAliasInSelect() {
        return true;
    }
}

