/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterValuesException;

public final class Parameterization {
    private static final int HASH_CODE_NOT_COMPUTED = -1;
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = Parameterization.class.getName().hashCode();
    private transient int hashCode = -1;
    private final IParameter parameter;
    private final String value;

    public Parameterization(IParameter parameter, String value) {
        if (parameter == null) {
            throw new NullPointerException("You cannot parameterize a null parameter");
        }
        this.parameter = parameter;
        this.value = value;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        void parameterization;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Parameterization)) {
            return false;
        }
        Parameterization parameterization2 = (Parameterization)object;
        if (!Objects.equals(this.parameter.getId(), parameterization.parameter.getId())) {
            return false;
        }
        return Objects.equals(this.value, parameterization.value);
    }

    public final IParameter getParameter() {
        return this.parameter;
    }

    public final String getValue() {
        return this.value;
    }

    public final String getValueName() throws ParameterValuesException {
        Map parameterValues = this.parameter.getValues().getParameterValues();
        Iterator parameterValueItr = parameterValues.entrySet().iterator();
        String returnValue = null;
        while (parameterValueItr.hasNext()) {
            Map.Entry entry = parameterValueItr.next();
            String currentValue = (String)entry.getValue();
            if (!Objects.equals(this.value, currentValue)) continue;
            returnValue = (String)entry.getKey();
            break;
        }
        if (returnValue == null) {
            return "";
        }
        return returnValue;
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = HASH_INITIAL * 89 + Objects.hashCode(this.parameter);
            this.hashCode = this.hashCode * 89 + Objects.hashCode(this.value);
            if (this.hashCode == -1) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }
}

