/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.log;

import java.util.Objects;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.qm.QMEvent;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;

public class SQLLogFilter
implements QMEventFilter {
    private SQLEditor editor;

    public SQLLogFilter(SQLEditor editor) {
        this.editor = editor;
    }

    public boolean accept(QMEvent event) {
        QMMObject object = event.getObject();
        if (object instanceof QMMConnectionInfo) {
            return this.editor.getDataSourceContainer() != null && Objects.equals(((QMMConnectionInfo)object).getContainerId(), this.editor.getDataSourceContainer().getId());
        }
        if (object instanceof QMMStatementExecuteInfo) {
            return this.belongsToExecutionContext(((QMMStatementExecuteInfo)object).getStatement().getConnection());
        }
        if (object instanceof QMMStatementInfo) {
            return this.belongsToExecutionContext(((QMMStatementInfo)object).getConnection());
        }
        if (object instanceof QMMTransactionInfo) {
            return this.belongsToExecutionContext(((QMMTransactionInfo)object).getConnection());
        }
        if (object instanceof QMMTransactionSavepointInfo) {
            return this.belongsToExecutionContext(((QMMTransactionSavepointInfo)object).getTransaction().getConnection());
        }
        return false;
    }

    public SQLEditor getEditor() {
        return this.editor;
    }

    private boolean belongsToExecutionContext(QMMConnectionInfo session) {
        String containerId = session.getContainerId();
        String contextName = session.getContextName();
        DBCExecutionContext executionContext = this.editor.getExecutionContext();
        return executionContext != null && Objects.equals(executionContext.getDataSource().getContainer().getId(), containerId) && Objects.equals(executionContext.getContextName(), contextName);
    }
}

