/*
 * Decompiled with CFR 0.152.
 */
package org.cts.units;

import java.io.Serializable;
import org.cts.units.Quantity;
import org.cts.units.Unit;

public class Measure
implements Serializable {
    private double svalue;
    private Number value;
    private Unit unit;
    private double precision = Double.NaN;

    public Measure(double value, Unit unit) {
        this(value, unit, Double.NaN);
    }

    public Measure(Number value, Unit unit) {
        this(value, unit, Double.NaN);
    }

    public Measure(Number value, Unit unit, double precision) {
        this.value = value;
        this.svalue = unit.toBaseUnit(value.doubleValue());
        this.unit = unit;
        this.precision = precision;
    }

    public double getSValue() {
        return this.svalue;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
        this.svalue = this.unit.toBaseUnit(value.doubleValue());
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Quantity getQuantity() {
        return this.unit.getQuantity();
    }

    public double getPrecision() {
        return this.precision;
    }

    public Measure toBaseUnit() {
        if (Double.isNaN(this.precision)) {
            return new Measure(this.svalue, this.unit.getBaseUnit(), Double.NaN);
        }
        return new Measure(this.svalue, this.unit.getBaseUnit(), this.unit.toBaseUnit(this.precision));
    }

    public Measure convert(Unit unit) throws IllegalArgumentException {
        if (Double.isNaN(this.precision)) {
            return new Measure(unit.fromBaseUnit(this.svalue), unit);
        }
        return new Measure(unit.fromBaseUnit(this.svalue), unit, unit.fromBaseUnit(this.unit.toBaseUnit(this.precision)));
    }

    public String toString() {
        String symb = this.unit.getSymbol();
        return this.value.toString() + (symb == null || symb.equals("") ? " " : symb) + (Double.isNaN(this.precision) ? "" : " \u00b1" + this.precision);
    }

    public Unit getCompatibleUnit(Unit ... units) {
        for (Unit unt : units) {
            if (!unt.getSymbol().equals(this.getUnit().getSymbol())) continue;
            return unt;
        }
        return null;
    }
}

