/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model.data;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCDateTimeValueHandler;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class ClickHouseDateTimeValueHandler
extends JDBCDateTimeValueHandler {
    public static final String CLICKHOUSE_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final SimpleDateFormat DEFAULT_DATETIME_FORMAT = new SimpleDateFormat("''yyyy-MM-dd HH:mm:ss''");

    public ClickHouseDateTimeValueHandler(DBDFormatSettings formatSettings) {
        super(formatSettings);
    }

    @Nullable
    protected Format getNativeValueFormat(DBSTypedObject type) {
        return DEFAULT_DATETIME_FORMAT;
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, @Nullable Object value) throws DBCException {
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            JDBCPreparedStatement dbStat = (JDBCPreparedStatement)statement;
            try {
                dbStat.setObject(index + 1, (Object)timestamp);
            }
            catch (SQLException e) {
                throw new DBCException(ModelMessages.model_jdbc_exception_could_not_bind_statement_parameter, (Throwable)e);
            }
        } else {
            super.bindValueObject(session, statement, type, index, value);
        }
    }
}

