/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public class DefaultColorSelector
extends ColorSelector {
    private RGB defaultColorValue;

    public DefaultColorSelector(@NotNull Composite parent, boolean rightClickResetsColor) {
        super(parent);
        if (rightClickResetsColor) {
            this.getButton().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if ((e.stateMask & 0x200000) > 0) {
                        DefaultColorSelector.this.setColorValue(DefaultColorSelector.this.getDefaultColorValue());
                        DefaultColorSelector.this.fireColorUpdateEvent(DefaultColorSelector.this.getColorValue(), DefaultColorSelector.this.getDefaultColorValue());
                    }
                }
            });
            this.getButton().setToolTipText(UIMessages.control_default_color_selector_reset_default_tip);
        }
    }

    protected void updateColorImage() {
        if (this.getColorValue() == null) {
            return;
        }
        super.updateColorImage();
        if (this.getColorValue() == this.getDefaultColorValue()) {
            Button button = this.getButton();
            Image image = button.getImage();
            Rectangle bounds = image.getBounds();
            GC gc = new GC((Drawable)image);
            Color color = UIUtils.getSharedColor(this.getColorValue());
            Color contrastColor = UIStyles.getContrastColor(color);
            Color blendedColor = UIUtils.getSharedColor(UIUtils.blend(color.getRGB(), contrastColor.getRGB(), 50));
            gc.setForeground(blendedColor);
            gc.drawRectangle(1, 1, bounds.width - 3, bounds.height - 3);
            gc.drawLine(2, 2, bounds.width - 3, bounds.height - 3);
            gc.drawLine(bounds.width - 3, 2, 2, bounds.height - 3);
            gc.dispose();
            button.setImage(image);
        }
    }

    @NotNull
    public RGB getDefaultColorValue() {
        return this.defaultColorValue;
    }

    public void setDefaultColorValue(@NotNull RGB defaultColorValue) {
        this.defaultColorValue = defaultColorValue;
        this.updateColorImage();
    }

    private void fireColorUpdateEvent(@NotNull RGB oldColor, @NotNull RGB newColor) {
        Object[] listeners = this.getListeners();
        if (listeners.length > 0) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "colorValue", (Object)oldColor, (Object)newColor);
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPropertyChangeListener)listener).propertyChange(event);
                ++n2;
            }
        }
    }
}

